/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.wyml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.creeperhost.wyml.MobManager;
import net.creeperhost.wyml.WhyYouMakeLag;
import net.creeperhost.wyml.config.ModSpawnConfig;
import net.creeperhost.wyml.config.WymlConfig;
import net.creeperhost.wyml.data.MobSpawnData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;

public class ChunkManager {
    MobCategory classification;
    ChunkPos chunk;
    DimensionType dimensionType;
    Level level;
    int spawningCount;
    private long startRate;
    private long finishRate;
    private int pauseTick;
    private int pausedFor;
    private int startSpawnSampleTick;
    private int lastSpawnRequestTick;
    private int spawnsInTick;
    private int slowModeStart;
    private int lastUpdatedTick;
    private boolean requiresSave;
    private boolean isPaused;
    private HashMap<Long, spawnLocation> prevSpawns = new HashMap();
    boolean slowMode;

    public ChunkManager(ChunkPos pos, DimensionType dimensionType, MobCategory classification) {
        this.classification = classification;
        this.chunk = pos;
        this.dimensionType = dimensionType;
    }

    public ChunkPos getChunk() {
        return this.chunk;
    }

    public MobCategory getClassification() {
        return this.classification;
    }

    public boolean isSlowMode() {
        return this.slowMode;
    }

    public long getFinishRate() {
        return this.finishRate;
    }

    public long getStartRate() {
        return this.startRate;
    }

    public boolean isSaved() {
        return !this.requiresSave;
    }

    public boolean isClaimed() {
        return WhyYouMakeLag.cachedClaimedChunks.get().contains(this.getChunk().m_45588_());
    }

    public boolean isForceLoaded() {
        return WhyYouMakeLag.cachedForceLoadedChunks.get().contains(this.getChunk().m_45588_());
    }

    public double getFailRate() {
        if (this.finishRate == 0L) {
            return 100.0;
        }
        if (this.startRate == 0L) {
            return 0.0;
        }
        double retVal = 100L - this.finishRate / this.startRate * 100L;
        if (this.finishRate > 0L) {
            double wat1 = (double)this.finishRate / (double)this.startRate;
            double wat2 = wat1 * 100.0;
            double wat3 = 100.0 - wat2;
            retVal = (double)Math.round(wat3 * 100.0) / 100.0;
        }
        if (retVal < 0.0) {
            return 0.0;
        }
        if (retVal > 100.0) {
            return 100.0;
        }
        return retVal;
    }

    public synchronized void increaseSpawningCount(BlockPos pos) {
        ++this.startRate;
        if (WhyYouMakeLag.getTicks() > this.startSpawnSampleTick + WymlConfig.cached().SAMPLE_TICKS) {
            this.startSpawnSampleTick = WhyYouMakeLag.getTicks();
            this.spawnsInTick = 0;
        }
        spawnLocation sl = new spawnLocation();
        if (this.prevSpawns.containsKey(pos.m_121878_())) {
            sl = this.prevSpawns.get(pos.m_121878_());
        }
        if (!sl.success) {
            sl.position = pos;
            sl.success = false;
            sl.lastUpdated = WhyYouMakeLag.getTicks();
        }
        this.prevSpawns.put(pos.m_121878_(), sl);
        ++this.spawnsInTick;
        this.lastSpawnRequestTick = WhyYouMakeLag.getTicks();
        ++this.spawningCount;
        this.requiresSave = true;
    }

    public void isSaving() {
        this.requiresSave = false;
        this.lastUpdatedTick = WhyYouMakeLag.getTicks();
    }

    public boolean hasExpired() {
        return this.lastUpdatedTick + WymlConfig.cached().MANAGER_CACHE_TICKS > WhyYouMakeLag.getTicks() && !this.isPaused() && this.isSaved();
    }

    public int countBlockCache() {
        return this.prevSpawns.size();
    }

    public synchronized int cleanBlockCache() {
        int removedCache = 0;
        try {
            ArrayList<Long> toRemove = new ArrayList<Long>();
            Set<Long> ids = this.prevSpawns.keySet();
            for (long id : ids) {
                spawnLocation sl = this.prevSpawns.get(id);
                if (sl.lastUpdated <= WhyYouMakeLag.getTicks() + WymlConfig.cached().SPAWNLOC_CACHE_TICKS && !sl.success) continue;
                toRemove.add(id);
            }
            for (long id : toRemove) {
                this.prevSpawns.remove(id);
                ++removedCache;
            }
            if (toRemove.size() > 0) {
                this.requiresSave = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return removedCache;
    }

    public synchronized void decreaseSpawningCount(BlockPos pos) {
        if (this.prevSpawns.containsKey(pos.m_121878_())) {
            spawnLocation sl = this.prevSpawns.get(pos.m_121878_());
            sl.success = true;
            sl.lastUpdated = WhyYouMakeLag.getTicks();
            this.prevSpawns.put(pos.m_121878_(), sl);
        }
        ++this.finishRate;
        if (this.finishRate > this.startRate) {
            this.startRate = this.finishRate;
        }
        --this.spawningCount;
        this.requiresSave = true;
    }

    public int getSpawnsInSample() {
        if (WhyYouMakeLag.getTicks() < this.startSpawnSampleTick + WymlConfig.cached().SAMPLE_TICKS) {
            int retVal = this.spawnsInTick;
            int sampleLength = WhyYouMakeLag.getTicks() - this.startSpawnSampleTick;
            if (sampleLength > 0) {
                retVal = this.spawnsInTick / sampleLength;
            }
            return retVal;
        }
        return 0;
    }

    public void resetSpawningCount() {
        this.spawningCount = 0;
        this.requiresSave = true;
    }

    public void slowMode() {
        this.resetSpawningCount();
        this.slowMode = true;
        this.slowModeStart = WhyYouMakeLag.getTicks();
        this.requiresSave = true;
    }

    public int ticksSinceSlow() {
        int diff = WhyYouMakeLag.getTicks() - this.slowModeStart;
        if (diff < 0) {
            diff = 99999;
        }
        return diff;
    }

    public void fastMode() {
        this.slowModeStart = 0;
        this.resetSpawningCount();
        this.slowMode = false;
        this.requiresSave = true;
    }

    public int getLastSpawnRequestTick() {
        return this.lastSpawnRequestTick;
    }

    public void pauseSpawns(int ticks) {
        this.isPaused = true;
        this.pausedFor = ticks;
        this.pauseTick = WhyYouMakeLag.getTicks();
        this.requiresSave = true;
    }

    public boolean reachedMobLimit(ResourceLocation resourceLocation) {
        return this.reachedMobLimit(resourceLocation.m_135827_(), resourceLocation.m_135815_());
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean reachedMobLimit(String modName, String mobName) {
        if (!WymlConfig.cached().ENABLE_PER_MOD_CONFIGS || !MobManager.canManage) {
            return false;
        }
        if (this.level == null) {
            for (ResourceKey levelKey : WhyYouMakeLag.minecraftServer.m_129784_()) {
                ServerLevel _level = WhyYouMakeLag.minecraftServer.m_129880_(levelKey);
                if (_level == null || _level.m_6042_() != this.dimensionType) continue;
                this.level = _level;
                break;
            }
        }
        if (this.level == null) {
            this.level = WhyYouMakeLag.minecraftServer.m_129880_(Level.f_46428_);
        }
        if (this.level == null || this.level.m_5776_()) {
            return false;
        }
        ProfilerFiller profilerFiller = this.level.m_46473_();
        profilerFiller.m_6180_("mobLimit");
        ChunkPos pos = this.getChunk();
        if (pos == null) {
            profilerFiller.m_7238_();
            return false;
        }
        int count = 0;
        try {
            int maxX = pos.m_45608_();
            int maxZ = pos.m_45609_();
            int minX = pos.m_45604_();
            int minZ = pos.m_45605_();
            int maxY = this.level.m_151558_();
            int minY = this.level.m_141937_();
            AABB aabb = new AABB((double)(pos.m_151390_() - minX), (double)minY, (double)(pos.m_151390_() - minZ), (double)(pos.m_151390_() + maxX), (double)maxY, (double)(pos.m_151390_() + maxZ));
            ResourceLocation resourceLocation = new ResourceLocation(modName, mobName);
            EntityType type = (EntityType)Registry.f_122826_.m_7745_(resourceLocation);
            if (type == null) {
                profilerFiller.m_7238_();
                return false;
            }
            List list = this.level.m_45933_(type.m_20615_(this.level), aabb);
            ArrayList<Entity> cleaned = new ArrayList<Entity>();
            for (Entity entity : list) {
                if (entity.m_6095_() != type) continue;
                cleaned.add(entity);
            }
            count = cleaned.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            profilerFiller.m_7238_();
            return false;
        }
        ModSpawnConfig modSpawnConfig = MobManager.getMod(modName);
        if (modSpawnConfig == null) {
            profilerFiller.m_7238_();
            return false;
        }
        MobSpawnData mobSpawnData = modSpawnConfig.getMob(mobName);
        if (mobSpawnData == null) {
            profilerFiller.m_7238_();
            return false;
        }
        profilerFiller.m_7238_();
        return count >= mobSpawnData.limit;
    }

    public boolean canPause() {
        boolean isPausable;
        boolean bl = isPausable = WymlConfig.cached().ALLOW_PAUSE && WhyYouMakeLag.minecraftServer.m_6846_().m_11309_() > WymlConfig.cached().MINIMUM_PAUSE_PLAYERS;
        if (isPausable) {
            if (WhyYouMakeLag.isFtbChunksLoaded() && !WymlConfig.cached().ALLOW_PAUSE_CLAIMED && this.isClaimed()) {
                return false;
            }
            if (!WymlConfig.cached().ALLOW_PAUSE_FORCED && this.isForceLoaded()) {
                return false;
            }
        }
        return isPausable;
    }

    public boolean isPaused() {
        int resumeRate;
        int n = resumeRate = this.isClaimed() ? WymlConfig.cached().RESUME_CLAIMED_RATE : WymlConfig.cached().RESUME_RATE;
        if (this.isPaused && this.pauseTick + this.pausedFor > WhyYouMakeLag.getTicks() || this.isPaused && this.getFailRate() < 100.0 - (double)resumeRate) {
            return true;
        }
        if (this.isPaused) {
            if (WymlConfig.cached().DEBUG_PRINT) {
                System.out.println("Resuming spawns for class " + this.getClassification().m_21607_() + " at " + this.getChunk() + " due to timeout or failure rate decease [" + this.getFailRate() + "%].");
            }
            this.isPaused = false;
            this.startRate = 0L;
            this.finishRate = 0L;
            this.resetSpawningCount();
            this.pauseTick = 0;
            this.pausedFor = 0;
            this.requiresSave = true;
        }
        return false;
    }

    public synchronized boolean isKnownBadLocation(BlockPos pos) {
        if (this.prevSpawns == null) {
            return false;
        }
        if (pos == null) {
            return false;
        }
        if (this.prevSpawns.containsKey(pos.m_121878_())) {
            spawnLocation sl = this.prevSpawns.get(pos.m_121878_());
            if (sl.lastUpdated < WhyYouMakeLag.getTicks() + WymlConfig.cached().SPAWNLOC_CACHE_TICKS) {
                return !sl.success;
            }
        }
        return false;
    }

    class spawnLocation {
        BlockPos position;
        boolean success;
        int lastUpdated;

        spawnLocation() {
        }
    }
}

