/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.wyml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.creeperhost.wyml.WhyYouMakeLag;
import net.creeperhost.wyml.config.WymlConfig;
import net.creeperhost.wyml.init.WYMLBlocks;
import net.creeperhost.wyml.tiles.TilePaperBag;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;

public class BagHandler {
    public static HashMap<Long, ItemEntity> MAP = new HashMap();
    public static List<Long> LIST_TO_REMOVE = new ArrayList<Long>();
    public static ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    public static boolean updating = false;
    public static int MIN_AGE = WymlConfig.cached().MIN_ITEM_AGE;
    public static int MIN_ITEMS = WymlConfig.cached().MIN_ITEM_COUNT;

    public static void create() {
        if (MAP == null) {
            MAP = new HashMap();
        }
        if (scheduledExecutorService.isShutdown()) {
            scheduledExecutorService = Executors.newScheduledThreadPool(1);
        }
        Runnable runnable = BagHandler::clean;
        scheduledExecutorService.scheduleAtFixedRate(runnable, 0L, 10L, TimeUnit.SECONDS);
    }

    public static void itemEntityAdded(ItemEntity itemEntity) {
        if (itemEntity == null) {
            return;
        }
        if (itemEntity.f_19853_.f_46443_) {
            return;
        }
        ChunkPos chunk = itemEntity.f_19853_.m_46745_(itemEntity.m_142538_()).m_7697_();
        if (chunk == null) {
            return;
        }
        if (MAP.containsKey(chunk.m_45588_())) {
            if (!updating) {
                BagHandler.update(chunk.m_45588_());
            }
            return;
        }
        if (!MAP.containsKey(chunk.m_45588_()) && BagHandler.getOtherItemsEntities(itemEntity).size() > MIN_ITEMS && itemEntity.m_6084_() && !itemEntity.m_32055_().m_41619_()) {
            MAP.put(chunk.m_45588_(), itemEntity);
            WhyYouMakeLag.LOGGER.info("added " + itemEntity.m_32055_().m_41611_().getString() + " To MAP " + chunk.toString());
            if (!updating) {
                BagHandler.update(chunk.m_45588_());
            }
        }
    }

    public static void clean() {
        if (LIST_TO_REMOVE.isEmpty()) {
            return;
        }
        WhyYouMakeLag.LOGGER.info("Cleaned up caches for BagHandler");
        for (Long aLong : LIST_TO_REMOVE) {
            MAP.remove(aLong);
        }
    }

    public static void update(long chunkLong) {
        updating = true;
        try {
            if (MAP.isEmpty()) {
                return;
            }
            ItemEntity itemEntity = MAP.get(chunkLong);
            if (itemEntity == null) {
                updating = false;
                MAP.remove(chunkLong);
                return;
            }
            if (!itemEntity.m_6084_()) {
                updating = false;
                return;
            }
            WhyYouMakeLag.LOGGER.info("Running update for BagHandler " + itemEntity.m_32055_().m_41611_().getString() + " Size " + BagHandler.getOtherItemsEntities(itemEntity).size());
            if (BagHandler.shouldSpawnBag(itemEntity)) {
                WhyYouMakeLag.LOGGER.info("More than " + MIN_ITEMS + " entities in chunk " + chunkLong);
                BagHandler.createBag(itemEntity);
            }
            LIST_TO_REMOVE.add(chunkLong);
        }
        catch (Exception e) {
            updating = false;
            e.printStackTrace();
        }
        updating = false;
    }

    public static boolean shouldSpawnBag(ItemEntity itemEntity) {
        List<ItemEntity> itemEntityList = BagHandler.getOtherItemsEntities(itemEntity);
        int maxAge = 0;
        if (itemEntityList.size() > MIN_ITEMS) {
            for (ItemEntity entity : itemEntityList) {
                if (entity.m_32059_() <= maxAge) continue;
                maxAge = entity.m_32059_();
            }
            return maxAge > MIN_AGE;
        }
        return false;
    }

    public static boolean createBag(ItemEntity itemEntity) {
        ServerLevel serverLevel = (ServerLevel)itemEntity.f_19853_;
        BlockPos paperBagPos = itemEntity.m_142538_();
        BlockPos first = BagHandler.getOtherItemsEntities(itemEntity).get(0).m_142538_();
        paperBagPos = first;
        if (paperBagPos == null) {
            WhyYouMakeLag.LOGGER.error("Unable to find location to spawn bag");
            return false;
        }
        if (serverLevel.m_7702_(paperBagPos) == null || serverLevel.m_7702_(paperBagPos) != null) {
            if (!(serverLevel.m_7702_(paperBagPos) instanceof TilePaperBag)) {
                serverLevel.m_46747_(paperBagPos);
            }
            if (serverLevel.m_8055_(paperBagPos) != ((Block)WYMLBlocks.PAPER_BAG.get()).m_49966_()) {
                serverLevel.m_7731_(paperBagPos, ((Block)WYMLBlocks.PAPER_BAG.get()).m_49966_(), 3);
                TilePaperBag tilePaperBag = (TilePaperBag)serverLevel.m_7702_(paperBagPos);
                if (tilePaperBag != null) {
                    tilePaperBag.collectItems();
                }
            }
        }
        return true;
    }

    public static List<ItemEntity> getOtherItemsEntities(ItemEntity itemEntity) {
        return itemEntity.f_19853_.m_45976_(ItemEntity.class, itemEntity.m_142469_().m_82377_(4.0, 4.0, 4.0));
    }
}

