/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.gui.buttons;

import com.leobeliik.extremesoundmuffler.CommonConfig;
import com.leobeliik.extremesoundmuffler.SoundMufflerCommon;
import com.leobeliik.extremesoundmuffler.gui.MufflerScreen;
import com.leobeliik.extremesoundmuffler.gui.buttons.PlaySoundButton;
import com.leobeliik.extremesoundmuffler.interfaces.IColorsGui;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;

public class MuffledSlider
extends AbstractWidget
implements ISoundLists,
IColorsGui {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private final Font font;
    private static boolean showSlider = false;
    private final ResourceLocation sound;
    private double sliderValue;
    private int bg;
    private Button btnToggleSound;
    private PlaySoundButton btnPlaySound;
    private MufflerScreen screen;
    private boolean isMuffling;

    public MuffledSlider(int x, int y, int bg, ResourceLocation sound, double sliderValue, MufflerScreen screen) {
        super(x, y, 205, 14, Component.m_130674_((String)(sound.m_135815_() + ":" + sound.m_135827_())));
        this.font = MuffledSlider.minecraft.f_91062_;
        this.isMuffling = false;
        this.bg = bg;
        this.sound = sound;
        this.sliderValue = sliderValue;
        this.screen = screen;
        this.setBtnToggleSound(sound);
        this.setBtnPlaySound(sound);
    }

    public void m_6303_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.isMuffling = this.getFGColor(this.getText(), "aqua");
        SoundMufflerCommon.renderGui();
        MuffledSlider.m_93172_((PoseStack)stack, (int)this.f_93620_, (int)(this.f_93621_ - 1), (int)(this.f_93620_ + this.f_93618_ + 4), (int)(this.f_93621_ + this.f_93619_ - 2), (int)this.bg);
        this.drawGradient(stack);
        float v = this.isMuffling ? 202.0f : 213.0f;
        MuffledSlider.m_93133_((PoseStack)stack, (int)this.btnToggleSound.f_93620_, (int)this.btnToggleSound.f_93621_, (float)43.0f, (float)v, (int)11, (int)11, (int)256, (int)256);
        MuffledSlider.m_93133_((PoseStack)stack, (int)this.btnPlaySound.f_93620_, (int)this.btnPlaySound.f_93621_, (float)32.0f, (float)202.0f, (int)11, (int)11, (int)256, (int)256);
        if (this.btnToggleSound.m_5953_((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (AbstractButton)this.btnToggleSound, (Component)(this.isMuffling ? new TranslatableComponent("slider.btn.muffler.unmuffle") : new TranslatableComponent("slider.btn.muffler.muffle")));
        }
        if (this.btnPlaySound.m_5953_(mouseX, mouseY)) {
            this.renderButtonTooltip(stack, this.btnPlaySound, (Component)new TranslatableComponent("slider.btn.play.play_sound"));
        }
        this.drawMessage(stack);
    }

    private void renderButtonTooltip(PoseStack stack, AbstractButton btn, Component text) {
        int lengthierText = this.font.m_92852_((FormattedText)text);
        int x1 = btn.f_93620_ + btn.m_93694_() / 2 - this.font.m_92852_((FormattedText)text) / 2;
        int x2 = x1 + lengthierText + 2;
        int n = btn.f_93621_;
        Objects.requireNonNull(this.font);
        int y1 = n - 9 - 2;
        int y2 = btn.f_93621_ - 1;
        MuffledSlider.m_93172_((PoseStack)stack, (int)(x1 - 3), (int)(y1 - 5), (int)x2, (int)(y2 + 1), (int)darkBG);
        this.font.m_92889_(stack, text, (float)x1, (float)(y1 - 2), 0xFFFFFF);
    }

    private void drawMessage(PoseStack stack) {
        int v = Math.max(this.f_93618_, this.font.m_92895_(this.m_6035_().getString()));
        if (showSlider && this.m_93696_() && this.f_93622_) {
            MuffledSlider.m_93208_((PoseStack)stack, (Font)this.font, (String)(new TranslatableComponent("slider.btn.volume").m_131328_() + (int)(this.sliderValue * 100.0)), (int)(this.f_93620_ + this.f_93618_ / 2), (int)(this.f_93621_ + 2), (int)65535);
        } else {
            String msgTruncated;
            if (this.f_93622_) {
                msgTruncated = this.m_6035_().getString();
                Objects.requireNonNull(this.font);
                MuffledSlider.m_93172_((PoseStack)stack, (int)(this.f_93620_ + this.f_93618_ + 3), (int)this.f_93621_, (int)(this.f_93620_ + v + 3), (int)(this.f_93621_ + 9 + 2), (int)darkBG);
            } else {
                msgTruncated = this.font.m_92854_((FormattedText)this.m_6035_(), 205).getString();
            }
            this.font.m_92750_(stack, msgTruncated, (float)(this.f_93620_ + 2), (float)(this.f_93621_ + 2), this.isMuffling ? 65535 : 0xFFFFFF);
        }
    }

    private void drawGradient(PoseStack stack) {
        if (this.isMuffling) {
            MuffledSlider.m_93133_((PoseStack)stack, (int)this.f_93620_, (int)(this.f_93621_ - 1), (float)0.0f, (float)234.0f, (int)((int)(this.sliderValue * (double)(this.f_93618_ - 6)) + 5), (int)(this.f_93619_ + 1), (int)256, (int)256);
            if (this.f_93622_) {
                MuffledSlider.m_93133_((PoseStack)stack, (int)(this.f_93620_ + (int)(this.sliderValue * (double)(this.f_93618_ - 6)) + 1), (int)(this.f_93621_ + 1), (float)32.0f, (float)224.0f, (int)5, (int)9, (int)256, (int)256);
            }
        }
    }

    public void isVisible(boolean b) {
        this.f_93624_ = b;
        this.getBtnToggleSound().f_93624_ = b;
        this.getBtnPlaySound().f_93624_ = b;
    }

    public void setY(int y) {
        this.f_93621_ = y;
        this.getBtnToggleSound().f_93621_ = y;
        this.getBtnPlaySound().f_93621_ = y;
    }

    private void setBtnToggleSound(ResourceLocation sound) {
        int x = CommonConfig.get().leftButtons().get() != false ? this.f_93620_ - 26 : this.f_93620_ + this.f_93618_ + 4;
        this.btnToggleSound = new Button(x, this.f_93621_, 11, 11, TextComponent.f_131282_, b -> {
            if (this.isMuffling) {
                if (this.screen.removeSoundMuffled(sound)) {
                    this.setFGColor(this, "white");
                }
            } else {
                this.setSliderValue(CommonConfig.get().defaultMuteVolume().get());
                if (this.screen.addSoundMuffled(sound, this.sliderValue)) {
                    this.setFGColor(this, "aqua");
                }
            }
        });
    }

    public Button getBtnToggleSound() {
        return this.btnToggleSound;
    }

    private void setBtnPlaySound(ResourceLocation sound) {
        this.btnPlaySound = new PlaySoundButton(this.btnToggleSound.f_93620_ + 13, this.f_93621_, new SoundEvent(sound));
    }

    private PlaySoundButton getBtnPlaySound() {
        return this.btnPlaySound;
    }

    private void changeSliderValue(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.f_93620_ + 4)) / (double)(this.f_93618_ - 8));
    }

    private void setSliderValue(double value) {
        double d0 = this.sliderValue;
        this.sliderValue = Mth.m_14008_((double)value, (double)0.0, (double)0.9);
        if (d0 != this.sliderValue) {
            this.func_230972_a_();
        }
        this.func_230979_b_();
        this.screen.replaceVolume(this.sound, this.sliderValue);
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        this.changeSliderValue((float)mouseX);
        super.m_7212_(mouseX, mouseY, dragX, dragY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.btnToggleSound.m_6375_(mouseX, mouseY, button);
        this.btnPlaySound.m_6375_(mouseX, mouseY, button);
        if (this.f_93622_ && this.isMuffling) {
            this.changeSliderValue((float)mouseX);
            showSlider = true;
            this.m_93692_(true);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.m_93692_(false);
        return super.m_6348_(mouseX, mouseY, button);
    }

    private void func_230979_b_() {
    }

    private void func_230972_a_() {
    }

    private MutableComponent getText() {
        return this.m_6035_().m_6881_();
    }

    public void m_142291_(NarrationElementOutput elementOutput) {
        elementOutput.m_169143_(NarratedElementType.TITLE, (String)(this.isMuffling ? new TranslatableComponent("slider.btn.volume").m_131328_() + (int)(this.sliderValue * 100.0) : this.sound.toString()));
    }
}

