/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script;

import dev.latvian.mods.kubejs.script.ScriptPackInfo;
import dev.latvian.mods.kubejs.script.ScriptSource;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ScriptFileInfo {
    private static final Pattern FILE_FIXER = Pattern.compile("[^\\w.\\/]");
    public final ScriptPackInfo pack;
    public final String file;
    public final ResourceLocation id;
    public final String location;
    private final Map<String, String> properties;
    private int priority;
    private boolean ignored;
    private String packMode;

    public ScriptFileInfo(ScriptPackInfo p, String f) {
        this.pack = p;
        this.file = f;
        this.id = new ResourceLocation(this.pack.namespace, FILE_FIXER.matcher(this.pack.pathStart + this.file).replaceAll("_").toLowerCase());
        this.location = UtilsJS.getID(this.pack.namespace + ":" + this.pack.pathStart + this.file);
        this.properties = new HashMap<String, String>();
        this.priority = 0;
        this.ignored = false;
        this.packMode = "default";
    }

    @Nullable
    public Throwable preload(ScriptSource source) {
        Throwable throwable;
        this.properties.clear();
        this.priority = 0;
        this.ignored = false;
        BufferedReader reader = new BufferedReader(new InputStreamReader(source.createStream(this), StandardCharsets.UTF_8));
        try {
            String line;
            while ((line = reader.readLine()) != null && (line = line.trim()).startsWith("//")) {
                String[] s = line.substring(2).split(":", 2);
                if (s.length != 2) continue;
                this.properties.put(s[0].trim().toLowerCase(), s[1].trim());
            }
            this.priority = Integer.parseInt(this.getProperty("priority", "0"));
            this.ignored = this.getProperty("ignored", "false").equals("true") || this.getProperty("ignore", "false").equals("true");
            this.packMode = this.getProperty("packmode", "default");
            throwable = null;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            catch (Throwable ex) {
                return ex;
            }
        }
        reader.close();
        return throwable;
    }

    public String getProperty(String s, String def) {
        return this.properties.getOrDefault(s, def);
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public String getPackMode() {
        return this.packMode;
    }
}

