/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.special;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.util.UUIDTypeAdapter;
import dev.architectury.core.AbstractRecipeSerializer;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.recipe.KubeJSRecipeEventHandler;
import dev.latvian.mods.kubejs.recipe.ModifyRecipeCraftingGrid;
import dev.latvian.mods.kubejs.recipe.ModifyRecipeResultCallback;
import dev.latvian.mods.kubejs.recipe.RecipeEventJS;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class ShapedKubeJSRecipe
extends ShapedRecipe {
    private final boolean mirror;
    private final List<IngredientAction> ingredientActions;
    private final ModifyRecipeResultCallback modifyResult;

    public ShapedKubeJSRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> ingredients, ItemStack result, boolean mirror, List<IngredientAction> ingredientActions, @Nullable ModifyRecipeResultCallback modifyResult) {
        super(id, group, width, height, ingredients, result);
        this.mirror = mirror;
        this.ingredientActions = ingredientActions;
        this.modifyResult = modifyResult;
    }

    public RecipeSerializer<?> m_7707_() {
        return KubeJSRecipeEventHandler.SHAPED.get();
    }

    public boolean m_5818_(CraftingContainer craftingContainer, Level level) {
        for (int i = 0; i <= craftingContainer.m_39347_() - this.f_44146_; ++i) {
            for (int j = 0; j <= craftingContainer.m_39346_() - this.f_44147_; ++j) {
                if (this.mirror && this.m_44170_(craftingContainer, i, j, true)) {
                    return true;
                }
                if (!this.m_44170_(craftingContainer, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack m_5874_(CraftingContainer container) {
        if (this.modifyResult != null) {
            return this.modifyResult.modify(new ModifyRecipeCraftingGrid(container), ItemStackJS.of(this.m_8043_().m_41777_())).getItemStack();
        }
        return this.m_8043_().m_41777_();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList list = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, (Object)IngredientAction.getRemaining(container, i, this.ingredientActions));
        }
        return list;
    }

    public static class SerializerKJS
    extends AbstractRecipeSerializer<ShapedKubeJSRecipe> {
        private static final RecipeSerializer<ShapedRecipe> SHAPED = (RecipeSerializer)UtilsJS.cast(KubeJSRegistries.recipeSerializers().get(new ResourceLocation("crafting_shaped")));

        public ShapedKubeJSRecipe fromJson(ResourceLocation id, JsonObject json) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)SHAPED.m_6729_(id, json);
            boolean mirror = GsonHelper.m_13855_((JsonObject)json, (String)"mirror", (boolean)true);
            boolean shrink = GsonHelper.m_13855_((JsonObject)json, (String)"shrink", (boolean)true);
            Map key = ShapedRecipe.m_44210_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipe.m_44196_((JsonArray)GsonHelper.m_13933_((JsonObject)json, (String)"pattern"));
            if (shrink) {
                pattern = ShapedRecipe.m_44186_((String[])pattern);
            }
            int w = pattern[0].length();
            int h = pattern.length;
            NonNullList ingredients = ShapedRecipe.m_44202_((String[])pattern, (Map)key, (int)w, (int)h);
            List<IngredientAction> ingredientActions = IngredientAction.parseList(json.get("kubejs_actions"));
            ModifyRecipeResultCallback modifyResult = null;
            if (json.has("kubejs_modify_result")) {
                modifyResult = RecipeEventJS.modifyResultCallbackMap.get(UUIDTypeAdapter.fromString((String)json.get("kubejs_modify_result").getAsString()));
            }
            return new ShapedKubeJSRecipe(id, shapedRecipe.m_6076_(), w, h, (NonNullList<Ingredient>)ingredients, shapedRecipe.m_8043_(), mirror, ingredientActions, modifyResult);
        }

        public ShapedKubeJSRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)SHAPED.m_8005_(id, buf);
            boolean mirror = buf.readBoolean();
            List<IngredientAction> ingredientActions = IngredientAction.readList(buf);
            String group = shapedRecipe.m_6076_();
            int width = shapedRecipe.m_44220_();
            int height = shapedRecipe.m_44221_();
            NonNullList ingredients = shapedRecipe.m_7527_();
            ItemStack result = shapedRecipe.m_8043_();
            return new ShapedKubeJSRecipe(id, group, width, height, (NonNullList<Ingredient>)ingredients, result, mirror, ingredientActions, null);
        }

        public void toNetwork(FriendlyByteBuf buf, ShapedKubeJSRecipe r) {
            SHAPED.m_6178_(buf, (Recipe)r);
            buf.writeBoolean(r.mirror);
            IngredientAction.writeList(buf, r.ingredientActions);
        }
    }
}

