/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.ingredientaction;

import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.util.MapJS;
import net.minecraft.world.item.ItemStack;

public class IngredientActionFilter {
    public int filterIndex = -1;
    public IngredientJS filterIngredient = null;

    public static IngredientActionFilter filterOf(Object o) {
        IngredientActionFilter filter = new IngredientActionFilter();
        if (o instanceof Number) {
            Number num = (Number)o;
            filter.filterIndex = num.intValue();
        } else if (o instanceof String || o instanceof IngredientJS) {
            filter.filterIngredient = IngredientJS.of(o);
            IngredientJS ingredientJS = filter.filterIngredient;
            if (ingredientJS instanceof ItemStackJS) {
                ItemStackJS stack = (ItemStackJS)ingredientJS;
                filter.filterIngredient = stack.ignoreNBT();
            }
        } else {
            MapJS map = MapJS.of(o);
            if (map != null && !map.isEmpty()) {
                if (map.containsKey("item")) {
                    filter.filterIngredient = IngredientJS.of(map.get("item"));
                }
                if (map.containsKey("index")) {
                    filter.filterIndex = ((Number)map.get("index")).intValue();
                }
            }
        }
        return filter;
    }

    public void copyFrom(IngredientActionFilter filter) {
        this.filterIndex = filter.filterIndex;
        this.filterIngredient = filter.filterIngredient;
    }

    public boolean checkFilter(int index, ItemStack stack) {
        return !(this.filterIndex != -1 && this.filterIndex != index || this.filterIngredient != null && !this.filterIngredient.testVanilla(stack));
    }
}

