/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import dev.latvian.mods.kubejs.item.ContainerInventory;
import dev.latvian.mods.kubejs.item.ItemHandler;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.item.ingredient.MatchAllIngredientJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import java.util.LinkedList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class InventoryJS {
    public final ItemHandler minecraftInventory;

    public InventoryJS(ItemHandler h) {
        this.minecraftInventory = h;
    }

    public InventoryJS(Container h) {
        this.minecraftInventory = new ContainerInventory(h);
    }

    public int getSize() {
        return this.minecraftInventory.getSlots();
    }

    public ItemStackJS get(int slot) {
        return ItemStackJS.of(this.minecraftInventory.getStackInSlot(slot));
    }

    public void set(int slot, ItemStack item) {
        if (!(this.minecraftInventory instanceof ItemHandler.Mutable)) {
            throw new IllegalStateException("This inventory can't be modified directly! Use insert/extract methods!");
        }
        ((ItemHandler.Mutable)this.minecraftInventory).setStackInSlot(slot, item);
    }

    public ItemStackJS insert(int slot, ItemStack item, boolean simulate) {
        return ItemStackJS.of(this.minecraftInventory.insertItem(slot, item, simulate));
    }

    public ItemStackJS extract(int slot, int amount, boolean simulate) {
        return ItemStackJS.of(this.minecraftInventory.extractItem(slot, amount, simulate));
    }

    public int getSlotLimit(int slot) {
        return this.minecraftInventory.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack item) {
        return this.minecraftInventory.isItemValid(slot, item);
    }

    public void clear() {
        ItemHandler.Mutable modInv = this.minecraftInventory instanceof ItemHandler.Mutable ? (ItemHandler.Mutable)this.minecraftInventory : null;
        for (int i = this.minecraftInventory.getSlots(); i >= 0; --i) {
            if (modInv != null) {
                modInv.setStackInSlot(i, ItemStack.f_41583_);
                continue;
            }
            this.minecraftInventory.extractItem(i, this.minecraftInventory.getStackInSlot(i).m_41613_(), false);
        }
    }

    public void clear(IngredientJS ingredient) {
        if (ingredient == MatchAllIngredientJS.INSTANCE) {
            this.clear();
        }
        ItemHandler.Mutable modInv = this.minecraftInventory instanceof ItemHandler.Mutable ? (ItemHandler.Mutable)this.minecraftInventory : null;
        for (int i = this.minecraftInventory.getSlots(); i >= 0; --i) {
            if (!ingredient.testVanilla(this.minecraftInventory.getStackInSlot(i))) continue;
            if (modInv != null) {
                modInv.setStackInSlot(i, ItemStack.f_41583_);
                continue;
            }
            this.minecraftInventory.extractItem(i, this.minecraftInventory.getStackInSlot(i).m_41613_(), false);
        }
    }

    public int find() {
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            ItemStack stack1 = this.minecraftInventory.getStackInSlot(i);
            if (stack1.m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public int find(IngredientJS ingredient) {
        if (ingredient == MatchAllIngredientJS.INSTANCE) {
            return this.find();
        }
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            ItemStack stack1 = this.minecraftInventory.getStackInSlot(i);
            if (!ingredient.testVanilla(stack1)) continue;
            return i;
        }
        return -1;
    }

    public int count() {
        int count = 0;
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            count += this.minecraftInventory.getStackInSlot(i).m_41613_();
        }
        return count;
    }

    public int count(IngredientJS ingredient) {
        if (ingredient == MatchAllIngredientJS.INSTANCE) {
            return this.count();
        }
        int count = 0;
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            ItemStack stack1 = this.minecraftInventory.getStackInSlot(i);
            if (!ingredient.testVanilla(stack1)) continue;
            count += stack1.m_41613_();
        }
        return count;
    }

    public int countNonEmpty() {
        int count = 0;
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            if (this.minecraftInventory.getStackInSlot(i).m_41619_()) continue;
            ++count;
        }
        return count;
    }

    public int countNonEmpty(IngredientJS ingredient) {
        if (ingredient == MatchAllIngredientJS.INSTANCE) {
            return this.countNonEmpty();
        }
        int count = 0;
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            ItemStack stack1 = this.minecraftInventory.getStackInSlot(i);
            if (!ingredient.testVanilla(stack1)) continue;
            ++count;
        }
        return count;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            if (this.minecraftInventory.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < this.getSize(); ++i) {
            list.add(this.get(i).toString());
        }
        return list.toString();
    }

    public void markDirty() {
        ItemHandler itemHandler = this.minecraftInventory;
        if (itemHandler instanceof ContainerInventory) {
            ContainerInventory container = (ContainerInventory)itemHandler;
            container.getInv().m_6596_();
        }
    }

    @Nullable
    public BlockContainerJS getBlock(LevelJS level) {
        ContainerInventory container;
        Container inv;
        ItemHandler itemHandler = this.minecraftInventory;
        if (itemHandler instanceof ContainerInventory && (inv = (container = (ContainerInventory)itemHandler).getInv()) instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)inv;
            return level.getBlock(be);
        }
        return null;
    }

    public int getWidth() {
        return this.minecraftInventory.getWidth();
    }

    public int getHeight() {
        return this.minecraftInventory.getHeight();
    }
}

