/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.integration.forge.gamestages;

import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.integration.forge.gamestages.GameStageEventJS;
import dev.latvian.mods.kubejs.integration.forge.gamestages.GameStagesPlayerData;
import dev.latvian.mods.kubejs.integration.forge.gamestages.GameStagesWrapper;
import dev.latvian.mods.kubejs.player.PlayerDataJS;
import dev.latvian.mods.kubejs.script.AttachDataEvent;
import dev.latvian.mods.kubejs.stages.Stages;
import net.darkhax.gamestages.event.GameStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;

public class GameStagesIntegration
extends KubeJSPlugin {
    private boolean gameStagesLoaded = false;

    @Override
    public void init() {
        if (ModList.get().isLoaded("gamestages")) {
            this.gameStagesLoaded = true;
            MinecraftForge.EVENT_BUS.addListener(e -> {
                new GameStageEventJS((GameStageEvent)e).post("gamestage.added", e.getStageName());
                Stages.invokeAdded(Stages.get(e.getPlayer()), e.getStageName());
            });
            MinecraftForge.EVENT_BUS.addListener(e -> {
                new GameStageEventJS((GameStageEvent)e).post("gamestage.removed", e.getStageName());
                Stages.invokeRemoved(Stages.get(e.getPlayer()), e.getStageName());
            });
            Stages.overrideCreation(event -> event.setPlayerStages(new GameStagesWrapper(event.getPlayer())));
        }
    }

    @Override
    public void attachPlayerData(AttachDataEvent<PlayerDataJS> event) {
        if (this.gameStagesLoaded) {
            event.add("gamestages", new GameStagesPlayerData(event.parent()));
        }
    }
}

