/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import dev.architectury.registry.registries.Registrar;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.entity.EntityJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.server.ServerJS;
import dev.latvian.mods.kubejs.util.ClassWrapper;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.ListJS;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.kubejs.util.WrappedJS;
import dev.latvian.mods.rhino.mod.util.CountingMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public interface UtilsWrapper {
    public static ServerJS getServer() {
        return ServerJS.instance;
    }

    public static void queueIO(Runnable runnable) {
        UtilsJS.queueIO(runnable);
    }

    public static Random getRandom() {
        return UtilsJS.RANDOM;
    }

    public static Random newRandom(long seed) {
        return new Random(seed);
    }

    public static <T> List<T> emptyList() {
        return Collections.emptyList();
    }

    public static <K, V> Map<K, V> emptyMap() {
        return Collections.emptyMap();
    }

    public static ListJS newList() {
        return new ListJS();
    }

    public static MapJS newMap() {
        return new MapJS();
    }

    public static CountingMap newCountingMap() {
        return new CountingMap();
    }

    public static ResourceLocation id(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    public static ResourceLocation id(ResourceLocation id) {
        return id;
    }

    public static ConsoleJS createConsole(String name) {
        return new ConsoleJS(ScriptType.STARTUP, LoggerFactory.getLogger((String)name));
    }

    public static Pattern regex(Object s) {
        Pattern pattern = UtilsJS.parseRegex(s);
        return pattern == null ? Pattern.compile(s.toString()) : pattern;
    }

    public static Pattern regex(String pattern, int flags) {
        return Pattern.compile(pattern, flags);
    }

    public static int parseInt(@Nullable Object object, int def) {
        return UtilsJS.parseInt(object, def);
    }

    public static double parseDouble(@Nullable Object object, double def) {
        return UtilsJS.parseDouble(object, def);
    }

    public static Stat<ResourceLocation> getStat(ResourceLocation id) {
        return Stats.f_12988_.m_12902_((Object)id);
    }

    public static LevelJS getLevel(Level level) {
        return UtilsJS.getLevel(level);
    }

    public static LevelJS getClientLevel() {
        return UtilsJS.getClientLevel();
    }

    @Nullable
    public static SoundEvent getSound(ResourceLocation id) {
        return (SoundEvent)KubeJSRegistries.soundEvents().get(id);
    }

    public static Object randomOf(Random random, Collection<Object> objects) {
        if (objects.isEmpty()) {
            return null;
        }
        if (objects instanceof List) {
            List list = (List)objects;
            return list.get(random.nextInt(objects.size()));
        }
        return new ArrayList<Object>(objects).get(random.nextInt(objects.size()));
    }

    public static long getSystemTime() {
        return System.currentTimeMillis();
    }

    public static ListJS rollChestLoot(ResourceLocation id) {
        return UtilsWrapper.rollChestLoot(id, null);
    }

    public static ListJS rollChestLoot(ResourceLocation id, @Nullable EntityJS entity) {
        return UtilsJS.rollChestLoot(id, entity);
    }

    @Nullable
    public static ListJS listOf(@Nullable Object o) {
        return ListJS.of(o);
    }

    public static ListJS listOrSelf(@Nullable Object o) {
        return ListJS.orSelf(o);
    }

    @Nullable
    public static MapJS mapOf(@Nullable Object o) {
        return MapJS.of(o);
    }

    @Nullable
    public static Object copy(@Nullable Object o) {
        return UtilsJS.copy(o);
    }

    public static boolean isWrapped(@Nullable Object o) {
        return o instanceof WrappedJS;
    }

    public static String toTitleCase(String s) {
        return UtilsJS.toTitleCase(s);
    }

    public static ClassWrapper<KubeJSRegistries> getRegistries() {
        return new ClassWrapper<KubeJSRegistries>(KubeJSRegistries.class);
    }

    public static Registrar<?> getRegistry(ResourceLocation id) {
        return Objects.requireNonNull(KubeJSRegistries.genericRegistry(ResourceKey.m_135788_((ResourceLocation)id)), "No builtin or static registry found for %s!".formatted(id));
    }

    public static Collection<ResourceLocation> getRegistryIds(ResourceLocation id) {
        return UtilsWrapper.getRegistry(id).getIds();
    }
}

