/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.wirelesschargers.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.wirelesschargers.ChargerType;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.advancements.AdventureAdvancements;
import net.minecraft.data.advancements.HusbandryAdvancements;
import net.minecraft.data.advancements.NetherAdvancements;
import net.minecraft.data.advancements.StoryAdvancements;
import net.minecraft.data.advancements.TheEndAdvancements;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChargerAdvancementProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    private final List<Consumer<Consumer<Advancement>>> tabs = ImmutableList.of((Object)new TheEndAdvancements(), (Object)new HusbandryAdvancements(), (Object)new AdventureAdvancements(), (Object)new NetherAdvancements(), (Object)new StoryAdvancements());

    public ChargerAdvancementProvider(GatherDataEvent e) {
        this.generator = e.getGenerator();
    }

    public void m_6865_(HashCache hashCache) {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.m_138327_());
            }
            Path advancementPath = ChargerAdvancementProvider.createPath(path, advancement);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)hashCache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)advancementPath);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)advancementPath, (Object)ioexception);
            }
        };
        Advancement wireless_charging = Advancement.Builder.m_138353_().m_138371_((ItemLike)ChargerType.BASIC_WIRELESS_PLAYER_CHARGER.getItem(), (Component)TextComponents.translation((String)"wirelesschargers.advancement.wireless_charging.title").get(), (Component)TextComponents.translation((String)"wirelesschargers.advancement.wireless_charging.description").get(), new ResourceLocation("minecraft", "textures/block/redstone_block.png"), FrameType.TASK, true, true, false).m_138360_(RequirementsStrategy.f_15979_).m_138386_("has_player_charger", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{ChargerType.BASIC_WIRELESS_PLAYER_CHARGER.getItem()})).m_138386_("has_block_charger", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{ChargerType.BASIC_WIRELESS_BLOCK_CHARGER.getItem()})).m_138389_(consumer, "wirelesschargers:wireless_charging");
        Advancement no_more_batteries = Advancement.Builder.m_138353_().m_138398_(wireless_charging).m_138371_((ItemLike)ChargerType.ADVANCED_WIRELESS_PLAYER_CHARGER.getItem(), (Component)TextComponents.translation((String)"wirelesschargers.advancement.no_more_batteries.title").get(), (Component)TextComponents.translation((String)"wirelesschargers.advancement.no_more_batteries.description").get(), null, FrameType.TASK, true, true, false).m_138386_("has_charger", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{ChargerType.ADVANCED_WIRELESS_PLAYER_CHARGER.getItem()})).m_138389_(consumer, "wirelesschargers:no_more_batteries");
        Advancement no_more_cables = Advancement.Builder.m_138353_().m_138398_(wireless_charging).m_138371_((ItemLike)ChargerType.ADVANCED_WIRELESS_BLOCK_CHARGER.getItem(), (Component)TextComponents.translation((String)"wirelesschargers.advancement.no_more_cables.title").get(), (Component)TextComponents.translation((String)"wirelesschargers.advancement.no_more_cables.description").get(), null, FrameType.TASK, true, true, false).m_138386_("has_charger", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{ChargerType.ADVANCED_WIRELESS_BLOCK_CHARGER.getItem()})).m_138389_(consumer, "wirelesschargers:no_more_cables");
    }

    private static Path createPath(Path path, Advancement advancement) {
        return path.resolve("data/" + advancement.m_138327_().m_135827_() + "/advancements/" + advancement.m_138327_().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Advancements";
    }
}

