/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.config;

import de.nekeras.borderless.util.Translatable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public enum FullscreenModeConfig implements Translatable
{
    BEST("The best suitable fullscreen mode for the current operating system."),
    BORDERLESS("A borderless fullscreen which sets the width and height of the window to the monitor's video mode and removing window borders."),
    NATIVE("A native fullscreen which changes the monitor's window mode in order to apply the fullscreen. Focus loss behaviour can be manually configured using the 'focusLoss' option.");

    private static final String BASE_KEY = "borderless.config.fullscreen_mode.%s";
    private final String comment;
    private final TranslatableComponent translation;

    private FullscreenModeConfig(String comment) {
        this.comment = comment;
        this.translation = new TranslatableComponent(String.format(BASE_KEY, this.name().toLowerCase()));
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public Component getTranslation() {
        return this.translation;
    }

    public String toString() {
        return this.translation.m_131328_();
    }
}

