/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.client.listener;

import de.nekeras.borderless.client.ReflectionUtils;
import de.nekeras.borderless.client.gui.ButtonOption;
import de.nekeras.borderless.client.gui.ConfigScreen;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.VideoSettingsScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="borderlesswindow", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class VideoSettingsListener {
    private static final String TITLE_KEY = "borderless.config.video_settings_button";
    private static final Logger log = LogManager.getLogger();

    @SubscribeEvent
    public static void onVideoSettings(@Nonnull ScreenEvent.InitScreenEvent.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof VideoSettingsScreen) {
            VideoSettingsScreen screen2 = (VideoSettingsScreen)screen;
            log.info("Opened VideoSettingsScreen");
            ReflectionUtils.getOptionsList(screen2).ifPresent(optionsList -> VideoSettingsListener.addToOptionsList(screen2, optionsList));
        }
    }

    private static void addToOptionsList(@Nonnull VideoSettingsScreen screen, @Nonnull OptionsList optionsRowList) {
        log.info("Found OptionsList");
        Minecraft minecraft = Minecraft.m_91087_();
        ButtonOption fullscreenOption = new ButtonOption(TITLE_KEY, btn -> minecraft.m_91152_((Screen)new ConfigScreen((Screen)screen)));
        optionsRowList.m_94471_((Option)fullscreenOption);
        VideoSettingsListener.moveLastEntryToStart(optionsRowList.m_6702_());
        log.info("Added Borderless Window Config Screen to OptionsList");
    }

    private static <T> void moveLastEntryToStart(List<T> list) {
        if (list.isEmpty()) {
            return;
        }
        T lastElement = list.remove(list.size() - 1);
        list.add(0, lastElement);
    }
}

