/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import de.nekeras.borderless.client.FullscreenDisplayModeHolder;
import de.nekeras.borderless.client.gui.ConfigScreenOption;
import de.nekeras.borderless.config.Config;
import de.nekeras.borderless.config.FocusLossConfig;
import de.nekeras.borderless.config.FullscreenModeConfig;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ConfigScreen
extends Screen {
    private static final String DESCRIPTION_KEY_BASE = "borderless.%s";
    private static final int LAYOUT_MAX_WIDTH = 250;
    private static final int WHITE = 0xFFFFFF;
    private static final int YELLOW = 0xFFFF00;
    private static final int RED = 0xFF0000;
    private static final int LINE_HEIGHT = 25;
    private static final Component titleText = new TranslatableComponent("borderless.config.title");
    private static final Component applyText = new TranslatableComponent("borderless.config.apply");
    private static final Component changedWarningText = new TranslatableComponent("borderless.config.changed");
    private static final Component disabledText = new TranslatableComponent("borderless.config.disabled.description");
    private static final Logger log = LogManager.getLogger();
    private final Screen parent;
    private AbstractWidget enabledButton;
    private AbstractWidget fullscreenModeButton;
    private AbstractWidget focusLossButton;

    public ConfigScreen(@Nonnull Screen parent) {
        super(titleText);
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        boolean initialEnabledState = (Boolean)Config.GENERAL.enabled.get();
        FullscreenModeConfig initialFullscreenMode = (FullscreenModeConfig)Config.GENERAL.fullscreenMode.get();
        FocusLossConfig initialFocusLossMode = (FocusLossConfig)Config.GENERAL.focusLoss.get();
        Minecraft minecraft = Minecraft.m_91087_();
        int x = this.getHorizontalLayoutStart(this.f_96543_);
        this.enabledButton = ConfigScreenOption.enabled.m_7496_(minecraft.f_91066_, x, 50, 250);
        this.fullscreenModeButton = ConfigScreenOption.fullscreenMode.m_7496_(minecraft.f_91066_, x, 75, 250);
        this.focusLossButton = ConfigScreenOption.focusLoss.m_7496_(minecraft.f_91066_, x, 100, 250);
        Button applyButton = new Button(this.f_96543_ / 2 - 125, this.f_96544_ - 75, 100, 20, applyText, btn -> {
            log.info("Apply button in Borderless Window Config Screen pressed");
            FullscreenDisplayModeHolder.setFullscreenDisplayModeFromConfig();
            this.m_7379_();
        });
        Button cancelButton = new Button(this.f_96543_ / 2 + 25, this.f_96544_ - 75, 100, 20, CommonComponents.f_130656_, btn -> {
            log.info("Cancel button in Borderless Window Config Screen pressed, resetting to {}, {}, {}", (Object)initialEnabledState, (Object)initialFullscreenMode, (Object)initialFocusLossMode);
            Config.GENERAL.enabled.set((Object)initialEnabledState);
            Config.GENERAL.fullscreenMode.set((Object)initialFullscreenMode);
            Config.GENERAL.focusLoss.set((Object)initialFocusLossMode);
            this.m_7379_();
        });
        this.m_142416_((GuiEventListener)this.enabledButton);
        this.m_142416_((GuiEventListener)this.fullscreenModeButton);
        this.m_142416_((GuiEventListener)this.focusLossButton);
        this.m_142416_((GuiEventListener)applyButton);
        this.m_142416_((GuiEventListener)cancelButton);
        this.refreshButtonStates();
    }

    public void m_96624_() {
        super.m_96624_();
        this.refreshButtonStates();
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float frameTime) {
        Minecraft minecraft = Minecraft.m_91087_();
        this.m_7333_(matrixStack);
        this.renderTitle(matrixStack, minecraft, this.f_96543_);
        this.renderDescription(minecraft, this.f_96543_);
        this.renderChangedWarning(minecraft, this.f_96543_, this.f_96544_);
        super.m_6305_(matrixStack, mouseX, mouseY, frameTime);
    }

    public void m_7379_() {
        super.m_7379_();
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    private void renderTitle(@Nonnull PoseStack matrixStack, @Nonnull Minecraft minecraft, int width) {
        ConfigScreen.m_93215_((PoseStack)matrixStack, (Font)minecraft.f_91062_, (Component)this.f_96539_, (int)(width / 2), (int)20, (int)0xFFFFFF);
    }

    private void renderDescription(@Nonnull Minecraft minecraft, int width) {
        int x = this.getHorizontalLayoutStart(width);
        int y = 125;
        if (((Boolean)Config.GENERAL.enabled.get()).booleanValue()) {
            minecraft.f_91062_.m_92857_((FormattedText)new TranslatableComponent(this.getDescriptionKey()), x, y, 250, 0xFFFFFF);
        } else {
            minecraft.f_91062_.m_92857_((FormattedText)disabledText, x, y, 250, 0xFF0000);
        }
    }

    private void renderChangedWarning(@Nonnull Minecraft minecraft, int width, int height) {
        int x = this.getHorizontalLayoutStart(width);
        int y = height - 50;
        minecraft.f_91062_.m_92857_((FormattedText)changedWarningText, x, y, 250, 0xFFFF00);
    }

    private String getDescriptionKey() {
        FullscreenModeConfig mode = (FullscreenModeConfig)Config.GENERAL.fullscreenMode.get();
        String modeKey = String.format(DESCRIPTION_KEY_BASE, mode.name().toLowerCase());
        if (mode != FullscreenModeConfig.NATIVE) {
            return modeKey;
        }
        FocusLossConfig focusLoss = (FocusLossConfig)Config.GENERAL.focusLoss.get();
        return String.format("%s.%s", modeKey, focusLoss.name().toLowerCase());
    }

    private void refreshButtonStates() {
        boolean enabled = (Boolean)Config.GENERAL.enabled.get();
        this.enabledButton.f_93624_ = true;
        this.fullscreenModeButton.f_93624_ = enabled;
        this.focusLossButton.f_93624_ = enabled && Config.GENERAL.fullscreenMode.get() == FullscreenModeConfig.NATIVE;
    }

    private int getHorizontalLayoutStart(int width) {
        return (width - 250) / 2;
    }
}

