/*
 * Decompiled with CFR 0.152.
 */
package de.nekeras.borderless.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.WindowEventHandler;
import de.nekeras.borderless.util.AccessibleFieldDelegate;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.screens.VideoSettingsScreen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl.glfw.GLFWWindowSizeCallbackI;

@OnlyIn(value=Dist.CLIENT)
public final class ReflectionUtils {
    private static final AccessibleFieldDelegate<Window, WindowEventHandler> windowEventListenerAccessor = ReflectionUtils.makeFieldAccessible(Window.class, WindowEventHandler.class);
    private static final AccessibleFieldDelegate<VideoSettingsScreen, OptionsList> optionsListAccessor = ReflectionUtils.tryMakeFieldAccessible(VideoSettingsScreen.class, OptionsList.class, thisRef -> null);

    private ReflectionUtils() {
    }

    @Nonnull
    private static <C, F> AccessibleFieldDelegate<C, F> makeFieldAccessible(@Nonnull Class<C> inClass, @Nonnull Class<F> fieldType) {
        try {
            return new AccessibleFieldDelegate<C, F>(inClass, fieldType);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(String.format("Expected field of type %s in class %s", inClass.getName(), fieldType.getName()), e);
        }
    }

    @Nonnull
    private static <C, F> AccessibleFieldDelegate<C, F> tryMakeFieldAccessible(@Nonnull Class<C> inClass, @Nonnull Class<F> fieldType, @Nonnull Function<C, F> defaultSupplier) {
        return new AccessibleFieldDelegate<C, F>(inClass, fieldType, defaultSupplier);
    }

    public static boolean isCalledByGlfwCallback() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(e -> e.getClassName().equals(GLFWFramebufferSizeCallbackI.class.getName()) || e.getClassName().equals(GLFWWindowSizeCallbackI.class.getName()));
    }

    public static void updateWindowEventListener(@Nonnull Window window, @Nonnull Function<WindowEventHandler, WindowEventHandler> updateSupplier) {
        WindowEventHandler oldListener = windowEventListenerAccessor.getValue(window);
        WindowEventHandler newListener = updateSupplier.apply(oldListener);
        windowEventListenerAccessor.setValue(window, newListener);
    }

    @Nonnull
    public static Optional<OptionsList> getOptionsList(@Nonnull VideoSettingsScreen screen) {
        return Optional.ofNullable(optionsListAccessor.getValue(screen));
    }
}

