/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.world;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.ToIntFunction;
import mekanism.common.registration.impl.SetupFeatureDeferredRegister;
import mekanism.common.registration.impl.SetupFeatureRegistryObject;
import mekanism.common.registries.MekanismFeatures;
import mekanism.common.world.ResizableOreFeature;
import mekanism.common.world.ResizableOreFeatureConfig;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class GenHandler {
    private GenHandler() {
    }

    public static void onBiomeLoad(BiomeLoadingEvent event) {
        if (GenHandler.isValidBiome(event.getCategory())) {
            BiomeGenerationSettingsBuilder generation = event.getGeneration();
            for (SetupFeatureDeferredRegister.MekFeature<ResizableOreFeatureConfig, ResizableOreFeature>[] features : MekanismFeatures.ORES.values()) {
                for (SetupFeatureDeferredRegister.MekFeature<ResizableOreFeatureConfig, ResizableOreFeature> feature : features) {
                    generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, feature.placedFeature());
                }
            }
            generation.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, MekanismFeatures.SALT.placedFeature());
        }
    }

    private static boolean isValidBiome(Biome.BiomeCategory biomeCategory) {
        return biomeCategory != Biome.BiomeCategory.THEEND && biomeCategory != Biome.BiomeCategory.NETHER;
    }

    public static boolean generate(ServerLevel world, ChunkPos chunkPos) {
        boolean generated = false;
        if (!SharedConstants.m_183707_((ChunkPos)chunkPos)) {
            BiomeSource biomeSource;
            List list;
            SectionPos sectionPos = SectionPos.m_123196_((ChunkPos)chunkPos, (int)world.m_151560_());
            BlockPos blockPos = sectionPos.m_123249_();
            ChunkGenerator chunkGenerator = world.m_7726_().m_8481_();
            WorldgenRandom random = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_189328_()));
            long decorationSeed = random.m_64690_(world.m_7328_(), blockPos.m_123341_(), blockPos.m_123343_());
            int decorationStep = GenerationStep.Decoration.UNDERGROUND_ORES.ordinal() - 1;
            ToIntFunction featureIndex = decorationStep < (list = (biomeSource = chunkGenerator.m_62218_()).m_186733_()).size() ? ((BiomeSource.StepFeatureData)list.get(decorationStep)).f_196678_() : feature -> -1;
            for (SetupFeatureDeferredRegister.MekFeature<ResizableOreFeatureConfig, ResizableOreFeature>[] features : MekanismFeatures.ORES.values()) {
                for (SetupFeatureDeferredRegister.MekFeature<ResizableOreFeatureConfig, ResizableOreFeature> feature2 : features) {
                    generated |= GenHandler.place((WorldGenLevel)world, chunkGenerator, blockPos, random, decorationSeed, decorationStep, featureIndex, feature2);
                }
            }
            generated |= GenHandler.place((WorldGenLevel)world, chunkGenerator, blockPos, random, decorationSeed, decorationStep, featureIndex, MekanismFeatures.SALT);
            world.m_183406_(null);
        }
        return generated;
    }

    private static boolean place(WorldGenLevel world, ChunkGenerator chunkGenerator, BlockPos blockPos, WorldgenRandom random, long decorationSeed, int decorationStep, ToIntFunction<PlacedFeature> featureIndex, SetupFeatureDeferredRegister.MekFeature<?, ?> feature) {
        SetupFeatureRegistryObject<?, ?> retrogen = feature.retrogen();
        PlacedFeature baseFeature = feature.feature().getPlacedFeature();
        random.m_190064_(decorationSeed, featureIndex.applyAsInt(baseFeature), decorationStep);
        world.m_183406_(() -> retrogen.getPlacedFeatureKey().toString());
        return retrogen.getPlacedFeature().m_191797_(new PlacementContext(world, chunkGenerator, Optional.of(baseFeature)), (Random)random, blockPos);
    }
}

