/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Random;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismPlacementModifiers;
import mekanism.common.resource.ore.OreType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class DisableableFeaturePlacement
extends PlacementFilter {
    public static final Codec<DisableableFeaturePlacement> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)OreType.OreVeinType.CODEC.optionalFieldOf("oreVeinType").forGetter(config -> Optional.ofNullable(config.oreVeinType)), (App)Codec.BOOL.fieldOf("retroGen").forGetter(config -> config.retroGen)).apply((Applicative)builder, (oreType, retroGen) -> {
        if (oreType.isPresent()) {
            OreType.OreVeinType type = (OreType.OreVeinType)oreType.get();
            return new DisableableFeaturePlacement(type, MekanismConfig.world.getVeinConfig(type).shouldGenerate(), (boolean)retroGen);
        }
        return new DisableableFeaturePlacement(null, MekanismConfig.world.salt.shouldGenerate, (boolean)retroGen);
    }));
    private final BooleanSupplier enabledSupplier;
    @Nullable
    private final OreType.OreVeinType oreVeinType;
    private final boolean retroGen;

    public DisableableFeaturePlacement(@Nullable OreType.OreVeinType oreVeinType, BooleanSupplier enabledSupplier, boolean retroGen) {
        this.oreVeinType = oreVeinType;
        this.enabledSupplier = enabledSupplier;
        this.retroGen = retroGen;
    }

    protected boolean m_183168_(@Nonnull PlacementContext context, @Nonnull Random random, @Nonnull BlockPos pos) {
        if (this.enabledSupplier.getAsBoolean()) {
            return !this.retroGen || MekanismConfig.world.enableRegeneration.get();
        }
        return false;
    }

    @Nonnull
    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)MekanismPlacementModifiers.DISABLEABLE.get();
    }
}

