/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.qio;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.qio.filter.QIOFilter;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.qio.TileEntityQIOFilterHandler;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityQIOImporter
extends TileEntityQIOFilterHandler {
    private static final int MAX_DELAY = 10;
    private int delay = 0;
    private boolean importWithoutFilter = true;

    public TileEntityQIOImporter(BlockPos pos, BlockState state) {
        super(MekanismBlocks.QIO_IMPORTER, pos, state);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (MekanismUtils.canFunction(this)) {
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            this.tryImport();
            this.delay = 10;
        }
    }

    private void tryImport() {
        QIOFrequency freq = this.getQIOFrequency();
        Direction direction = this.getDirection();
        BlockEntity back = WorldUtils.getTileEntity((BlockGetter)this.m_58904_(), this.f_58858_.m_142300_(direction.m_122424_()));
        if (freq == null || !InventoryUtils.isItemHandler(back, direction)) {
            return;
        }
        if (!this.importWithoutFilter && this.getFilters().isEmpty()) {
            return;
        }
        Optional capability = CapabilityUtils.getCapability((ICapabilityProvider)back, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction).resolve();
        if (capability.isEmpty()) {
            return;
        }
        IItemHandler inventory = (IItemHandler)capability.get();
        HashSet<HashedItem> typesAdded = new HashSet<HashedItem>();
        int maxTypes = this.getMaxTransitTypes();
        int maxCount = this.getMaxTransitCount();
        int countAdded = 0;
        for (int i = inventory.getSlots() - 1; i >= 0; --i) {
            ItemStack ret;
            HashedItem type;
            ItemStack stack = inventory.extractItem(i, maxCount - countAdded, true);
            if (stack.m_41619_() || !typesAdded.contains(type = HashedItem.create(stack)) && typesAdded.size() == maxTypes || !this.canFilter(stack)) continue;
            ItemStack used = TransporterManager.getToUse(stack, freq.addItem(stack));
            if (!InventoryUtils.areItemsStackable(used, ret = inventory.extractItem(i, used.m_41613_(), false)) || used.m_41613_() != ret.m_41613_()) {
                Mekanism.logger.error("QIO insertion error: item handler {} returned {} during simulated extraction, but returned {} during execution. This is wrong!", (Object)back, (Object)stack, (Object)ret);
            }
            typesAdded.add(type);
            countAdded += used.m_41613_();
        }
    }

    private boolean canFilter(ItemStack stack) {
        if (this.importWithoutFilter && this.getFilters().isEmpty()) {
            return true;
        }
        for (QIOFilter<?> filter : this.getFilters()) {
            if (!filter.getFinder().modifies(stack)) continue;
            return true;
        }
        return false;
    }

    @ComputerMethod
    public boolean getImportWithoutFilter() {
        return this.importWithoutFilter;
    }

    public void toggleImportWithoutFilter() {
        this.importWithoutFilter = !this.importWithoutFilter;
        this.markForSave();
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(this::getImportWithoutFilter, value -> {
            this.importWithoutFilter = value;
        }));
    }

    @Override
    public void writeSustainedData(CompoundTag dataMap) {
        super.writeSustainedData(dataMap);
        dataMap.m_128379_("auto", this.importWithoutFilter);
    }

    @Override
    public void readSustainedData(CompoundTag dataMap) {
        super.readSustainedData(dataMap);
        NBTUtils.setBooleanIfPresent(dataMap, "auto", value -> {
            this.importWithoutFilter = value;
        });
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Map<String, String> remap = super.getTileDataRemap();
        remap.put("auto", "auto");
        return remap;
    }

    @ComputerMethod
    private void setImportsWithoutFilter(boolean value) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.importWithoutFilter != value) {
            this.toggleImportWithoutFilter();
        }
    }
}

