/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.laser;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.LaserEnergyContainer;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.laser.TileEntityLaserReceptor;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityLaserTractorBeam
extends TileEntityLaserReceptor {
    public TileEntityLaserTractorBeam(BlockPos pos, BlockState state) {
        super(MekanismBlocks.LASER_TRACTOR_BEAM, pos, state);
    }

    @Override
    protected void addInitialEnergyContainers(EnergyContainerHelper builder, IContentsListener listener) {
        this.energyContainer = LaserEnergyContainer.create(BasicEnergyContainer.notExternal, BasicEnergyContainer.internalOnly, this, listener);
        builder.addContainer(this.energyContainer);
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        for (int slotX = 0; slotX < 9; ++slotX) {
            for (int slotY = 0; slotY < 3; ++slotY) {
                OutputInventorySlot slot = OutputInventorySlot.at(listener, 8 + slotX * 18, 16 + slotY * 18);
                builder.addSlot(slot);
                slot.setSlotType(ContainerSlotType.NORMAL);
            }
        }
        return builder.build();
    }

    @Override
    protected void handleBreakBlock(BlockState state, BlockPos hitPos) {
        List drops = Block.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)this.f_58857_), (BlockPos)hitPos, (BlockEntity)WorldUtils.getTileEntity((BlockGetter)this.f_58857_, hitPos));
        if (!drops.isEmpty()) {
            List<IInventorySlot> inventorySlots = this.getInventorySlots(null);
            for (ItemStack drop : drops) {
                IInventorySlot slot;
                Iterator<IInventorySlot> iterator = inventorySlots.iterator();
                while (iterator.hasNext() && !(drop = (slot = iterator.next()).insertItem(drop, Action.EXECUTE, AutomationType.INTERNAL)).m_41619_()) {
                }
                if (drop.m_41619_()) continue;
                Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)drop);
            }
        }
    }

    @Override
    protected boolean handleHitItem(ItemEntity entity) {
        IInventorySlot slot;
        ItemStack stack = entity.m_32055_();
        Iterator<IInventorySlot> iterator = this.getInventorySlots(null).iterator();
        while (iterator.hasNext() && !(stack = (slot = iterator.next()).insertItem(stack, Action.EXECUTE, AutomationType.INTERNAL)).m_41619_()) {
        }
        if (stack.m_41619_()) {
            entity.m_146870_();
        }
        return true;
    }

    @ComputerMethod
    private int getSlotCount() {
        return this.getSlots();
    }

    @ComputerMethod
    private ItemStack getItemInSlot(int slot) throws ComputerException {
        int slots = this.getSlotCount();
        if (slot < 0 || slot >= slots) {
            throw new ComputerException("Slot: '%d' is out of bounds, as this laser amplifier only has '%d' slots (zero indexed).", slot, slots);
        }
        return this.getStackInSlot(slot);
    }
}

