/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import mekanism.common.Mekanism;
import mekanism.common.base.IChemicalConstant;
import mekanism.common.registration.impl.FluidRegistryObject;
import mekanism.common.registration.impl.ItemDeferredRegister;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class FluidDeferredRegister {
    private static final ResourceLocation OVERLAY = new ResourceLocation("minecraft", "block/water_overlay");
    private static final ResourceLocation LIQUID = Mekanism.rl("liquid/liquid");
    private static final ResourceLocation LIQUID_FLOW = Mekanism.rl("liquid/liquid_flow");
    private static final DispenseItemBehavior BUCKET_DISPENSE_BEHAVIOR = new DefaultDispenseItemBehavior(){

        @Nonnull
        public ItemStack m_7498_(@Nonnull BlockSource source, @Nonnull ItemStack stack) {
            BlockPos pos;
            ServerLevel world = source.m_7727_();
            DispensibleContainerItem bucket = (DispensibleContainerItem)stack.m_41720_();
            if (bucket.m_142073_(null, (Level)world, pos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)), null)) {
                bucket.m_142131_(null, (Level)world, stack, pos);
                return new ItemStack((ItemLike)Items.f_42446_);
            }
            return super.m_7498_(source, stack);
        }
    };
    private final List<FluidRegistryObject<?, ?, ?, ?>> allFluids = new ArrayList();
    private final DeferredRegister<Fluid> fluidRegister;
    private final DeferredRegister<Block> blockRegister;
    private final DeferredRegister<Item> itemRegister;

    public static FluidAttributes.Builder getMekBaseBuilder() {
        return FluidDeferredRegister.getMekBaseBuilder(LIQUID, LIQUID_FLOW);
    }

    public static FluidAttributes.Builder getMekBaseBuilder(ResourceLocation still, ResourceLocation flowing) {
        return FluidAttributes.builder((ResourceLocation)still, (ResourceLocation)flowing).sound(SoundEvents.f_11781_, SoundEvents.f_11778_).overlay(OVERLAY);
    }

    public FluidDeferredRegister(String modid) {
        this.blockRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)modid);
        this.fluidRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)modid);
        this.itemRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modid);
    }

    public FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> registerLiquidChemical(IChemicalConstant constants) {
        int density = Math.round(constants.getDensity());
        return this.register(constants.getName(), fluidAttributes -> fluidAttributes.color(constants.getColor()).temperature(Math.round(constants.getTemperature())).density(density).viscosity(density).luminosity(constants.getLuminosity()));
    }

    public FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> register(String name, UnaryOperator<FluidAttributes.Builder> fluidAttributes) {
        return this.register(name, BucketItem::new, fluidAttributes);
    }

    public <BUCKET extends BucketItem> FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BUCKET> register(String name, BucketCreator<BUCKET> bucketCreator, UnaryOperator<FluidAttributes.Builder> fluidAttributes) {
        return this.register(name, (FluidAttributes.Builder)fluidAttributes.apply(FluidDeferredRegister.getMekBaseBuilder()), bucketCreator);
    }

    public FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BucketItem> register(String name, FluidAttributes.Builder builder) {
        return this.register(name, builder, BucketItem::new);
    }

    public <BUCKET extends BucketItem> FluidRegistryObject<ForgeFlowingFluid.Source, ForgeFlowingFluid.Flowing, LiquidBlock, BUCKET> register(String name, FluidAttributes.Builder builder, BucketCreator<BUCKET> bucketCreator) {
        String flowingName = "flowing_" + name;
        String bucketName = name + "_bucket";
        FluidRegistryObject fluidRegistryObject = new FluidRegistryObject();
        ForgeFlowingFluid.Properties properties = new ForgeFlowingFluid.Properties(fluidRegistryObject::getStillFluid, fluidRegistryObject::getFlowingFluid, builder).bucket(fluidRegistryObject::getBucket).block(fluidRegistryObject::getBlock);
        fluidRegistryObject.updateStill(this.fluidRegister.register(name, () -> new ForgeFlowingFluid.Source(properties)));
        fluidRegistryObject.updateFlowing(this.fluidRegister.register(flowingName, () -> new ForgeFlowingFluid.Flowing(properties)));
        fluidRegistryObject.updateBucket(this.itemRegister.register(bucketName, () -> bucketCreator.create(fluidRegistryObject::getStillFluid, ItemDeferredRegister.getMekBaseProperties().m_41487_(1).m_41495_(Items.f_42446_))));
        fluidRegistryObject.updateBlock(this.blockRegister.register(name, () -> new LiquidBlock(fluidRegistryObject::getStillFluid, BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60978_(100.0f).m_60993_())));
        this.allFluids.add(fluidRegistryObject);
        return fluidRegistryObject;
    }

    public void register(IEventBus bus) {
        this.blockRegister.register(bus);
        this.fluidRegister.register(bus);
        this.itemRegister.register(bus);
    }

    public List<FluidRegistryObject<?, ?, ?, ?>> getAllFluids() {
        return Collections.unmodifiableList(this.allFluids);
    }

    public void registerBucketDispenserBehavior() {
        for (FluidRegistryObject<?, ?, ?, ?> fluidRO : this.getAllFluids()) {
            DispenserBlock.m_52672_(fluidRO.getBucket(), (DispenseItemBehavior)BUCKET_DISPENSE_BEHAVIOR);
        }
    }

    @FunctionalInterface
    public static interface BucketCreator<BUCKET extends BucketItem> {
        public BUCKET create(Supplier<? extends Fluid> var1, Item.Properties var2);
    }
}

