/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.chemical.ItemStackToChemicalRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class ItemStackToChemicalRecipeSerializer<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends ItemStackToChemicalRecipe<CHEMICAL, STACK>>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RECIPE> {
    private final IFactory<CHEMICAL, STACK, RECIPE> factory;

    protected ItemStackToChemicalRecipeSerializer(IFactory<CHEMICAL, STACK, RECIPE> factory) {
        this.factory = factory;
    }

    protected abstract STACK fromJson(@Nonnull JsonObject var1, @Nonnull String var2);

    protected abstract STACK fromBuffer(@Nonnull FriendlyByteBuf var1);

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray input = GsonHelper.m_13885_((JsonObject)json, (String)"input") ? GsonHelper.m_13933_((JsonObject)json, (String)"input") : GsonHelper.m_13930_((JsonObject)json, (String)"input");
        ItemStackIngredient inputIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)input);
        STACK output = this.fromJson(json, "output");
        if (((ChemicalStack)output).isEmpty()) {
            throw new JsonSyntaxException("Recipe output must not be empty.");
        }
        return this.factory.create(recipeId, inputIngredient, output);
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        try {
            ItemStackIngredient inputIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
            STACK output = this.fromBuffer(buffer);
            return this.factory.create(recipeId, inputIngredient, output);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading itemstack to chemical recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull RECIPE recipe) {
        try {
            ((ItemStackToChemicalRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing itemstack to chemical recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends ItemStackToChemicalRecipe<CHEMICAL, STACK>> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, STACK var3);
    }
}

