/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation.capability;

import java.util.Random;
import javax.annotation.Nonnull;
import mekanism.api.radiation.capability.IRadiationEntity;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.CapabilityCache;
import mekanism.common.capabilities.resolver.BasicCapabilityResolver;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.network.to_client.PacketRadiationData;
import mekanism.common.registries.MekanismDamageSource;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class DefaultRadiationEntity
implements IRadiationEntity {
    private double radiation;
    private double clientSeverity = 0.0;

    @Override
    public double getRadiation() {
        return this.radiation;
    }

    @Override
    public void radiate(double magnitude) {
        this.radiation += magnitude;
    }

    @Override
    public void update(@Nonnull LivingEntity entity) {
        Player player;
        if (entity instanceof Player && !MekanismUtils.isPlayingMode(player = (Player)entity)) {
            return;
        }
        Random rand = entity.f_19853_.m_5822_();
        double minSeverity = MekanismConfig.general.radiationNegativeEffectsMinSeverity.get();
        double severityScale = RadiationManager.RadiationScale.getScaledDoseSeverity(this.radiation);
        double chance = minSeverity + rand.nextDouble() * (1.0 - minSeverity);
        float strength = 0.0f;
        if (severityScale > chance) {
            strength = Math.max(1.0f, (float)Math.log1p(this.radiation));
            if (rand.nextBoolean()) {
                entity.m_6469_((DamageSource)MekanismDamageSource.RADIATION, strength);
            }
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)entity;
            if (this.clientSeverity != this.radiation) {
                this.clientSeverity = this.radiation;
                PacketRadiationData.sync(player2);
            }
            if (strength > 0.0f) {
                player2.m_36324_().m_38703_(strength);
            }
        }
    }

    @Override
    public void set(double magnitude) {
        this.radiation = magnitude;
    }

    @Override
    public void decay() {
        this.radiation = Math.max(1.0E-7, this.radiation * MekanismConfig.general.radiationTargetDecayRate.get());
    }

    public CompoundTag serializeNBT() {
        CompoundTag ret = new CompoundTag();
        ret.m_128347_("radiation", this.radiation);
        return ret;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.radiation = nbt.m_128459_("radiation");
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        public static final ResourceLocation NAME = Mekanism.rl("radiation");
        private final IRadiationEntity defaultImpl = new DefaultRadiationEntity();
        private final CapabilityCache capabilityCache = new CapabilityCache();

        public Provider() {
            this.capabilityCache.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.RADIATION_ENTITY_CAPABILITY, this.defaultImpl));
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction side) {
            return this.capabilityCache.getCapability(capability, side);
        }

        public void invalidate() {
            this.capabilityCache.invalidate(Capabilities.RADIATION_ENTITY_CAPABILITY, null);
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.defaultImpl.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.defaultImpl.deserializeNBT((Tag)nbt);
        }
    }
}

