/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.multiblock;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.common.lib.multiblock.IMultiblock;
import mekanism.common.lib.multiblock.IStructureValidator;
import mekanism.common.lib.multiblock.MultiblockCache;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.WorldUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MultiblockManager<T extends MultiblockData> {
    private static final Set<MultiblockManager<?>> managers = new ObjectOpenHashSet();
    private final String name;
    private final String nameLower;
    private final Supplier<MultiblockCache<T>> cacheSupplier;
    private final Supplier<IStructureValidator<T>> validatorSupplier;
    public final Map<UUID, CacheWrapper> inventories = new Object2ObjectOpenHashMap();

    public MultiblockManager(String name, Supplier<MultiblockCache<T>> cacheSupplier, Supplier<IStructureValidator<T>> validatorSupplier) {
        this.name = name;
        this.nameLower = name.toLowerCase(Locale.ROOT);
        this.cacheSupplier = cacheSupplier;
        this.validatorSupplier = validatorSupplier;
        managers.add(this);
    }

    public MultiblockCache<T> createCache() {
        return this.cacheSupplier.get();
    }

    public IStructureValidator<T> createValidator() {
        return this.validatorSupplier.get();
    }

    public String getName() {
        return this.name;
    }

    public String getNameLower() {
        return this.nameLower;
    }

    @Nullable
    public static UUID getMultiblockID(TileEntityMultiblock<?> tile) {
        return tile.getMultiblock().inventoryID;
    }

    public boolean isCompatible(BlockEntity tile) {
        if (tile instanceof IMultiblock) {
            IMultiblock multiblock = (IMultiblock)tile;
            return multiblock.getManager() == this;
        }
        return false;
    }

    public static void reset() {
        for (MultiblockManager<?> manager : managers) {
            manager.inventories.clear();
        }
    }

    public void invalidate(IMultiblock<?> multiblock) {
        CacheWrapper cache = this.inventories.get(multiblock.getCacheID());
        if (cache != null) {
            cache.locations.remove(multiblock.getTileCoord());
            if (cache.locations.isEmpty()) {
                this.inventories.remove(multiblock.getCacheID());
            }
        }
    }

    public MultiblockCache<T> pullInventory(Level world, UUID id) {
        CacheWrapper toReturn = this.inventories.get(id);
        for (Coord4D obj : toReturn.locations) {
            BlockEntity tile = WorldUtils.getTileEntity(BlockEntity.class, (BlockGetter)world, obj.getPos());
            if (!(tile instanceof IMultiblock)) continue;
            IMultiblock multiblock = (IMultiblock)tile;
            multiblock.resetCache();
        }
        this.inventories.remove(id);
        return toReturn.getCache();
    }

    public UUID getUniqueInventoryID() {
        return UUID.randomUUID();
    }

    public void updateCache(IMultiblock<T> tile, T multiblock) {
        this.inventories.computeIfAbsent(tile.getCacheID(), id -> new CacheWrapper()).update(tile, multiblock);
    }

    public class CacheWrapper {
        private MultiblockCache<T> cache;
        private final Set<Coord4D> locations = new ObjectOpenHashSet();

        private CacheWrapper() {
        }

        public MultiblockCache<T> getCache() {
            return this.cache;
        }

        public void update(IMultiblock<T> tile, T multiblock) {
            if (((MultiblockData)multiblock).isFormed()) {
                if (tile.isMaster()) {
                    if (!tile.hasCache()) {
                        tile.setCache(MultiblockManager.this.createCache());
                        this.locations.add(tile.getTileCoord());
                    } else if (this.cache != tile.getCache()) {
                        this.locations.add(tile.getTileCoord());
                    }
                    tile.getCache().sync(multiblock);
                    this.cache = tile.getCache();
                }
            } else if (tile.hasCache()) {
                if (this.cache != tile.getCache()) {
                    this.cache = tile.getCache();
                    this.locations.add(tile.getTileCoord());
                }
            } else if (this.cache != null) {
                tile.setCache(this.cache);
                this.locations.add(tile.getTileCoord());
            }
        }
    }
}

