/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.annotations.NonNull;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.network.to_client.container.property.RegistryEntryPropertyData;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SyncableRegistryEntry<V extends IForgeRegistryEntry<V>>
implements ISyncableData {
    private final Supplier<@NonNull V> getter;
    private final Consumer<@NonNull V> setter;
    private V lastKnownValue;

    public static <V extends IForgeRegistryEntry<V>> SyncableRegistryEntry<V> create(Supplier<@NonNull V> getter, Consumer<@NonNull V> setter) {
        return new SyncableRegistryEntry<V>(getter, setter);
    }

    private SyncableRegistryEntry(Supplier<@NonNull V> getter, Consumer<@NonNull V> setter) {
        this.getter = getter;
        this.setter = setter;
    }

    @Nonnull
    public V get() {
        return (V)((IForgeRegistryEntry)this.getter.get());
    }

    public void set(@Nonnull V value) {
        this.setter.accept(value);
    }

    @Override
    public ISyncableData.DirtyType isDirty() {
        V oldValue = this.get();
        boolean dirty = oldValue != this.lastKnownValue;
        this.lastKnownValue = oldValue;
        return ISyncableData.DirtyType.get(dirty);
    }

    @Override
    public RegistryEntryPropertyData<?> getPropertyData(short property, ISyncableData.DirtyType dirtyType) {
        return new RegistryEntryPropertyData<V>(property, this.get());
    }
}

