/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.BasicEnergyContainer;
import mekanism.common.capabilities.energy.VariableCapacityEnergyContainer;
import mekanism.common.content.network.distribution.EnergyAcceptorTarget;
import mekanism.common.content.network.distribution.EnergyTransmitterSaveTarget;
import mekanism.common.content.network.transmitter.UniversalCable;
import mekanism.common.lib.transmitter.DynamicBufferedNetwork;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;

public class EnergyNetwork
extends DynamicBufferedNetwork<IStrictEnergyHandler, EnergyNetwork, FloatingLong, UniversalCable>
implements IMekanismStrictEnergyHandler {
    private final List<IEnergyContainer> energyContainers;
    public final VariableCapacityEnergyContainer energyContainer;
    private FloatingLong prevTransferAmount = FloatingLong.ZERO;
    private FloatingLong floatingLongCapacity = FloatingLong.ZERO;

    public EnergyNetwork(UUID networkID) {
        super(networkID);
        this.energyContainer = VariableCapacityEnergyContainer.create(this::getCapacityAsFloatingLong, BasicEnergyContainer.alwaysTrue, BasicEnergyContainer.alwaysTrue, (IContentsListener)this);
        this.energyContainers = Collections.singletonList(this.energyContainer);
    }

    public EnergyNetwork(Collection<EnergyNetwork> networks) {
        this(UUID.randomUUID());
        this.adoptAllAndRegister(networks);
    }

    @Override
    protected void forceScaleUpdate() {
        this.currentScale = !this.energyContainer.isEmpty() && !this.energyContainer.getMaxEnergy().isZero() ? Math.min(1.0f, this.energyContainer.getEnergy().divide(this.energyContainer.getMaxEnergy()).floatValue()) : 0.0f;
    }

    @Override
    public List<UniversalCable> adoptTransmittersAndAcceptorsFrom(EnergyNetwork net) {
        FloatingLong oldCapacity = this.getCapacityAsFloatingLong();
        List<UniversalCable> transmittersToUpdate = super.adoptTransmittersAndAcceptorsFrom(net);
        FloatingLong ourScale = this.currentScale == 0.0f ? FloatingLong.ZERO : oldCapacity.multiply(this.currentScale);
        FloatingLong theirScale = net.currentScale == 0.0f ? FloatingLong.ZERO : net.getCapacityAsFloatingLong().multiply(net.currentScale);
        FloatingLong capacity = this.getCapacityAsFloatingLong();
        this.currentScale = Math.min(1.0f, capacity.isZero() ? 0.0f : ourScale.add(theirScale).divide(this.getCapacityAsFloatingLong()).floatValue());
        if (!this.isRemote() && !net.energyContainer.isEmpty()) {
            this.energyContainer.setEnergy(this.energyContainer.getEnergy().add(net.getBuffer()));
            net.energyContainer.setEmpty();
        }
        return transmittersToUpdate;
    }

    @Override
    @Nonnull
    public FloatingLong getBuffer() {
        return this.energyContainer.getEnergy();
    }

    @Override
    public void absorbBuffer(UniversalCable transmitter) {
        FloatingLong energy = transmitter.releaseShare();
        if (!energy.isZero()) {
            this.energyContainer.setEnergy(this.energyContainer.getEnergy().add(energy));
        }
    }

    @Override
    public void clampBuffer() {
        if (!this.energyContainer.isEmpty()) {
            FloatingLong capacity = this.getCapacityAsFloatingLong();
            if (this.energyContainer.getEnergy().greaterThan(capacity)) {
                this.energyContainer.setEnergy(capacity);
            }
        }
    }

    @Override
    protected synchronized void updateCapacity(UniversalCable transmitter) {
        this.floatingLongCapacity = this.floatingLongCapacity.plusEqual(transmitter.getCapacityAsFloatingLong());
        this.capacity = this.floatingLongCapacity.longValue();
    }

    @Override
    public synchronized void updateCapacity() {
        FloatingLong sum = FloatingLong.ZERO;
        for (UniversalCable transmitter : this.transmitters) {
            sum = sum.plusEqual(transmitter.getCapacityAsFloatingLong());
        }
        if (!this.floatingLongCapacity.equals(sum)) {
            this.floatingLongCapacity = sum;
            this.capacity = this.floatingLongCapacity.longValue();
        }
    }

    @Nonnull
    public FloatingLong getCapacityAsFloatingLong() {
        return this.floatingLongCapacity;
    }

    @Override
    protected void updateSaveShares(@Nullable UniversalCable triggerTransmitter) {
        super.updateSaveShares(triggerTransmitter);
        if (!this.isEmpty()) {
            EnergyTransmitterSaveTarget saveTarget = new EnergyTransmitterSaveTarget(this.transmitters);
            EmitUtils.sendToAcceptors(saveTarget, this.energyContainer.getEnergy().copy());
            saveTarget.saveShare();
        }
    }

    private FloatingLong tickEmit(FloatingLong energyToSend) {
        Collection acceptorValues = this.acceptorCache.getAcceptorValues();
        EnergyAcceptorTarget target = new EnergyAcceptorTarget(acceptorValues.size() * 2);
        for (Map acceptors : acceptorValues) {
            for (LazyOptional lazyAcceptor : acceptors.values()) {
                lazyAcceptor.ifPresent(acceptor -> {
                    if (acceptor.insertEnergy(energyToSend, Action.SIMULATE).smallerThan(energyToSend)) {
                        target.addHandler(acceptor);
                    }
                });
            }
        }
        return EmitUtils.sendToAcceptors(target, energyToSend.copy());
    }

    public String toString() {
        return "[EnergyNetwork] " + this.transmittersSize() + " transmitters, " + this.getAcceptorCount() + " acceptors.";
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.needsUpdate) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTransferEvent(this));
            this.needsUpdate = false;
        }
        if (this.energyContainer.isEmpty()) {
            this.prevTransferAmount = FloatingLong.ZERO;
        } else {
            this.prevTransferAmount = this.tickEmit(this.energyContainer.getEnergy());
            this.energyContainer.extract(this.prevTransferAmount, Action.EXECUTE, AutomationType.INTERNAL);
        }
    }

    @Override
    protected float computeContentScale() {
        float scale = (float)this.energyContainer.getEnergy().divideToLevel(this.energyContainer.getMaxEnergy());
        float ret = Math.max(this.currentScale, scale);
        if (!this.prevTransferAmount.isZero() && ret < 1.0f) {
            ret = Math.min(1.0f, ret + 0.02f);
        } else if (this.prevTransferAmount.isZero() && ret > 0.0f) {
            ret = Math.max(scale, ret - 0.02f);
        }
        return ret;
    }

    @Override
    public Component getNeededInfo() {
        return EnergyDisplay.of(this.energyContainer.getNeeded()).getTextComponent();
    }

    @Override
    public Component getStoredInfo() {
        return EnergyDisplay.of(this.energyContainer.getEnergy()).getTextComponent();
    }

    @Override
    public Component getFlowInfo() {
        return MekanismLang.GENERIC_PER_TICK.translate(EnergyDisplay.of(this.prevTransferAmount));
    }

    @Override
    public Object getNetworkReaderCapacity() {
        return this.getCapacityAsFloatingLong();
    }

    @Override
    public Component getTextComponent() {
        return MekanismLang.NETWORK_DESCRIPTION.translate(MekanismLang.ENERGY_NETWORK, this.transmittersSize(), this.getAcceptorCount());
    }

    @Override
    @Nonnull
    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyContainers;
    }

    @Override
    public void onContentsChanged() {
        this.markDirty();
    }

    public static class EnergyTransferEvent
    extends DynamicBufferedNetwork.TransferEvent<EnergyNetwork> {
        public EnergyTransferEvent(EnergyNetwork network) {
            super(network);
        }
    }
}

