/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.ModelRenderer;
import mekanism.client.render.data.FluidRenderData;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.content.evaporation.EvaporationMultiblockData;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationController;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.profiling.ProfilerFiller;

@ParametersAreNonnullByDefault
public class RenderThermalEvaporationPlant
extends MekanismTileEntityRenderer<TileEntityThermalEvaporationController> {
    public RenderThermalEvaporationPlant(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void render(TileEntityThermalEvaporationController tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        EvaporationMultiblockData multiblock;
        if (tile.isMaster() && (multiblock = (EvaporationMultiblockData)tile.getMultiblock()).isFormed() && multiblock.renderLocation != null && !multiblock.inputTank.isEmpty()) {
            FluidRenderData data = new FluidRenderData(multiblock.inputTank.getFluid());
            data.location = multiblock.renderLocation.m_142082_(1, 0, 1);
            data.height = multiblock.height() - 2;
            data.length = 2;
            data.width = 2;
            matrix.m_85836_();
            BlockPos pos = tile.m_58899_();
            int glow = data.calculateGlowLight(MekanismRenderer.FULL_SKY_LIGHT);
            matrix.m_85837_((double)(data.location.m_123341_() - pos.m_123341_()), (double)(data.location.m_123342_() - pos.m_123342_()), (double)(data.location.m_123343_() - pos.m_123343_()));
            VertexConsumer buffer = renderer.m_6299_(Sheets.m_110792_());
            MekanismRenderer.Model3D model = ModelRenderer.getModel(data, Math.min(1.0f, multiblock.prevScale));
            MekanismRenderer.renderObject(model, matrix, buffer, data.getColorARGB(multiblock.prevScale), glow, overlayLight, this.getFaceDisplay(data, model));
            matrix.m_85849_();
            MekanismRenderer.renderValves(matrix, buffer, multiblock.valves, data, pos, glow, overlayLight, this.isInsideMultiblock(data));
        }
    }

    @Override
    protected String getProfilerSection() {
        return "thermalEvaporationController";
    }

    public boolean shouldRenderOffScreen(TileEntityThermalEvaporationController tile) {
        if (tile.isMaster()) {
            EvaporationMultiblockData multiblock = (EvaporationMultiblockData)tile.getMultiblock();
            return multiblock.isFormed() && !multiblock.inputTank.isEmpty() && multiblock.renderLocation != null;
        }
        return false;
    }
}

