/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.element.button.GuiCloseButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.inventory.container.IEmptyContainer;
import mekanism.common.inventory.container.IGUIWindow;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.lib.Color;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class GuiWindow
extends GuiTexturedElement
implements IGUIWindow {
    private static final Color OVERLAY_COLOR = Color.rgbai(60, 60, 60, 128);
    private final SelectedWindowData windowData;
    private boolean dragging = false;
    private double dragX;
    private double dragY;
    private int prevDX;
    private int prevDY;
    private Consumer<GuiWindow> closeListener;
    private Consumer<GuiWindow> reattachListener;
    protected InteractionStrategy interactionStrategy = InteractionStrategy.CONTAINER;

    private static SelectedWindowData.WindowPosition calculateOpenPosition(IGuiWrapper gui, SelectedWindowData windowData, int x, int y, int width, int height) {
        int lastY;
        SelectedWindowData.WindowPosition lastPosition = windowData.getLastPosition();
        int lastX = lastPosition.x();
        if (lastX != Integer.MAX_VALUE) {
            int guiLeft = gui.getLeft();
            if (guiLeft + lastX < 0) {
                lastX = -guiLeft;
            } else if (guiLeft + lastX + width > minecraft.m_91268_().m_85445_()) {
                lastX = minecraft.m_91268_().m_85445_() - guiLeft - width;
            }
        }
        if ((lastY = lastPosition.y()) != Integer.MAX_VALUE) {
            int guiTop = gui.getTop();
            if (guiTop + lastY < 0) {
                lastY = -guiTop;
            } else if (guiTop + lastY + height > minecraft.m_91268_().m_85446_()) {
                lastY = minecraft.m_91268_().m_85446_() - guiTop - height;
            }
        }
        return new SelectedWindowData.WindowPosition(lastX == Integer.MAX_VALUE ? x : lastX, lastY == Integer.MAX_VALUE ? y : lastY);
    }

    public GuiWindow(IGuiWrapper gui, int x, int y, int width, int height, SelectedWindowData.WindowType windowType) {
        this(gui, x, y, width, height, windowType == SelectedWindowData.WindowType.UNSPECIFIED ? SelectedWindowData.UNSPECIFIED : new SelectedWindowData(windowType));
    }

    public GuiWindow(IGuiWrapper gui, int x, int y, int width, int height, SelectedWindowData windowData) {
        this(gui, GuiWindow.calculateOpenPosition(gui, windowData, x, y, width, height), width, height, windowData);
    }

    private GuiWindow(IGuiWrapper gui, SelectedWindowData.WindowPosition calculatedPosition, int width, int height, SelectedWindowData windowData) {
        super(GuiMekanism.BASE_BACKGROUND, gui, calculatedPosition.x(), calculatedPosition.y(), width, height);
        this.windowData = windowData;
        this.isOverlay = true;
        this.f_93623_ = true;
        if (!this.isFocusOverlay()) {
            this.addCloseButton();
        }
    }

    public void onFocusLost() {
    }

    public void onFocused() {
        this.gui().setSelectedWindow(this.windowData);
    }

    protected void addCloseButton() {
        this.addChild(new GuiCloseButton(this.gui(), this.relativeX + 6, this.relativeY + 6, this));
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        GuiMekanism gui;
        AbstractContainerMenu c;
        IGuiWrapper iGuiWrapper;
        boolean ret = super.m_6375_(mouseX, mouseY, button);
        if (this.m_5953_(mouseX, mouseY)) {
            if (mouseY < (double)(this.f_93621_ + 18)) {
                this.dragging = true;
                this.dragX = mouseX;
                this.dragY = mouseY;
                this.prevDX = 0;
                this.prevDY = 0;
            }
        } else if (!ret && this.interactionStrategy.allowContainer() && (iGuiWrapper = this.gui()) instanceof GuiMekanism && !((c = (gui = (GuiMekanism)iGuiWrapper).m_6262_()) instanceof IEmptyContainer) && mouseX >= (double)this.getGuiLeft() && mouseX < (double)(this.getGuiLeft() + this.getGuiWidth()) && mouseY >= (double)(this.getGuiTop() + this.getGuiHeight() - 90)) {
            return false;
        }
        return ret || !this.interactionStrategy.allowAll();
    }

    @Override
    public void m_7212_(double mouseX, double mouseY, double mouseXOld, double mouseYOld) {
        super.m_7212_(mouseX, mouseY, mouseXOld, mouseYOld);
        if (this.dragging) {
            int newDX = (int)Math.round(mouseX - this.dragX);
            int newDY = (int)Math.round(mouseY - this.dragY);
            int changeX = Math.max(-this.f_93620_, Math.min(minecraft.m_91268_().m_85445_() - (this.f_93620_ + this.f_93618_), newDX - this.prevDX));
            int changeY = Math.max(-this.f_93621_, Math.min(minecraft.m_91268_().m_85446_() - (this.f_93621_ + this.f_93619_), newDY - this.prevDY));
            this.prevDX = newDX;
            this.prevDY = newDY;
            this.move(changeX, changeY);
        }
    }

    @Override
    public void m_7691_(double mouseX, double mouseY) {
        super.m_7691_(mouseX, mouseY);
        this.dragging = false;
    }

    @Override
    public void renderBackgroundOverlay(PoseStack matrix, int mouseX, int mouseY) {
        if (this.isFocusOverlay()) {
            MekanismRenderer.renderColorOverlay(matrix, 0, 0, minecraft.m_91268_().m_85445_(), minecraft.m_91268_().m_85446_(), OVERLAY_COLOR.rgba());
        } else {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            GuiUtils.renderBackgroundTexture(matrix, GuiMekanism.SHADOW, 4, 4, this.getButtonX() - 3, this.getButtonY() - 3, this.getButtonWidth() + 6, this.getButtonHeight() + 6, 256, 256);
            MekanismRenderer.resetColor();
        }
        this.renderBackgroundTexture(matrix, this.getResource(), 4, 4);
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256) {
            this.close();
            return true;
        }
        return false;
    }

    public void setListenerTab(Supplier<? extends GuiElement> elementSupplier) {
        this.setTabListeners(window -> {
            ((GuiElement)elementSupplier.get()).f_93623_ = true;
        }, window -> {
            ((GuiElement)elementSupplier.get()).f_93623_ = false;
        });
    }

    public void setTabListeners(Consumer<GuiWindow> closeListener, Consumer<GuiWindow> reattachListener) {
        this.closeListener = closeListener;
        this.reattachListener = reattachListener;
    }

    @Override
    public void resize(int prevLeft, int prevTop, int left, int top) {
        super.resize(prevLeft, prevTop, left, top);
        if (this.reattachListener != null) {
            this.reattachListener.accept(this);
        }
    }

    public void renderBlur(PoseStack matrix) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        GuiUtils.renderBackgroundTexture(matrix, GuiMekanism.BLUR, 4, 4, this.relativeX, this.relativeY, this.f_93618_, this.f_93619_, 256, 256);
        MekanismRenderer.resetColor();
    }

    public void close() {
        this.gui().removeWindow(this);
        this.children.forEach(GuiElement::onWindowClose);
        if (this.closeListener != null) {
            this.closeListener.accept(this);
        }
        this.windowData.updateLastPosition(this.relativeX, this.relativeY);
    }

    protected boolean isFocusOverlay() {
        return false;
    }

    @Override
    public void drawTitleText(PoseStack matrix, Component text, float y) {
        if (this.isFocusOverlay()) {
            super.drawTitleText(matrix, text, y);
        } else {
            int leftShift = this.getTitlePadStart();
            int xSize = this.getXSize() - leftShift - this.getTitlePadEnd();
            int maxLength = xSize - 12;
            float textWidth = this.getStringWidth(text);
            float scale = Math.min(1.0f, (float)maxLength / textWidth);
            float left = (float)this.relativeX + (float)xSize / 2.0f;
            this.drawScaledCenteredText(matrix, text, left + (float)leftShift, (float)this.relativeY + y, this.titleTextColor(), scale);
        }
    }

    protected int getTitlePadStart() {
        return 12;
    }

    protected int getTitlePadEnd() {
        return 0;
    }

    public static enum InteractionStrategy {
        NONE,
        CONTAINER,
        ALL;


        boolean allowContainer() {
            return this != NONE;
        }

        boolean allowAll() {
            return this == ALL;
        }
    }
}

