/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.image.BufferedImage;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiScalableElement;
import mekanism.common.Mekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;

public class GuiElementHolder
extends GuiScalableElement {
    public static final ResourceLocation HOLDER = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "element_holder.png");
    public static final int HOLDER_SIZE = 32;
    private static int BACKGROUND_COLOR = -8882056;

    public GuiElementHolder(IGuiWrapper gui, int x, int y, int width, int height) {
        super(HOLDER, gui, x, y, width, height, 32, 32);
    }

    @Override
    public void m_6303_(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.renderBackgroundTexture(matrix, this.getResource(), this.sideWidth, this.sideHeight);
    }

    @Override
    public void drawBackground(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
    }

    public static int getBackgroundColor() {
        return BACKGROUND_COLOR;
    }

    public static void updateBackgroundColor() {
        try {
            Resource resource = Minecraft.m_91087_().m_91098_().m_142591_(HOLDER);
            BufferedImage img = ImageIO.read(resource.m_6679_());
            int rgb = img.getRGB(33, 33);
            if (rgb >> 24 == 0) {
                rgb = -8882056;
                Mekanism.logger.warn("Unable to retrieve background color for element holder.");
            }
            BACKGROUND_COLOR = rgb;
        }
        catch (Exception e) {
            Mekanism.logger.error("Failed to retrieve background color for element holder", (Throwable)e);
        }
    }
}

