/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.creator;

import java.util.function.Consumer;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.creator.IChemicalStackIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IFluidStackIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IItemStackIngredientCreator;

public class IngredientCreatorAccess {
    private static IItemStackIngredientCreator ITEM_STACK_INGREDIENT_CREATOR;
    private static IFluidStackIngredientCreator FLUID_STACK_INGREDIENT_CREATOR;
    private static IChemicalStackIngredientCreator<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient> GAS_STACK_INGREDIENT_CREATOR;
    private static IChemicalStackIngredientCreator<InfuseType, InfusionStack, ChemicalStackIngredient.InfusionStackIngredient> INFUSION_STACK_INGREDIENT_CREATOR;
    private static IChemicalStackIngredientCreator<Pigment, PigmentStack, ChemicalStackIngredient.PigmentStackIngredient> PIGMENT_STACK_INGREDIENT_CREATOR;
    private static IChemicalStackIngredientCreator<Slurry, SlurryStack, ChemicalStackIngredient.SlurryStackIngredient> SLURRY_STACK_INGREDIENT_CREATOR;

    private IngredientCreatorAccess() {
    }

    public static IChemicalStackIngredientCreator<?, ?, ?> getCreatorForType(ChemicalType chemicalType) {
        return switch (chemicalType) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalType.GAS -> IngredientCreatorAccess.gas();
            case ChemicalType.INFUSION -> IngredientCreatorAccess.infusion();
            case ChemicalType.PIGMENT -> IngredientCreatorAccess.pigment();
            case ChemicalType.SLURRY -> IngredientCreatorAccess.slurry();
        };
    }

    public static IItemStackIngredientCreator item() {
        if (ITEM_STACK_INGREDIENT_CREATOR == null) {
            IngredientCreatorAccess.lookupInstance(IItemStackIngredientCreator.class, "mekanism.common.recipe.ingredient.creator.ItemStackIngredientCreator", helper -> {
                ITEM_STACK_INGREDIENT_CREATOR = helper;
            });
        }
        return ITEM_STACK_INGREDIENT_CREATOR;
    }

    public static IFluidStackIngredientCreator fluid() {
        if (FLUID_STACK_INGREDIENT_CREATOR == null) {
            IngredientCreatorAccess.lookupInstance(IFluidStackIngredientCreator.class, "mekanism.common.recipe.ingredient.creator.FluidStackIngredientCreator", helper -> {
                FLUID_STACK_INGREDIENT_CREATOR = helper;
            });
        }
        return FLUID_STACK_INGREDIENT_CREATOR;
    }

    public static IChemicalStackIngredientCreator<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient> gas() {
        if (GAS_STACK_INGREDIENT_CREATOR == null) {
            IngredientCreatorAccess.lookupInstance(IChemicalStackIngredientCreator.class, "mekanism.common.recipe.ingredient.creator.GasStackIngredientCreator", helper -> {
                GAS_STACK_INGREDIENT_CREATOR = helper;
            });
        }
        return GAS_STACK_INGREDIENT_CREATOR;
    }

    public static IChemicalStackIngredientCreator<InfuseType, InfusionStack, ChemicalStackIngredient.InfusionStackIngredient> infusion() {
        if (INFUSION_STACK_INGREDIENT_CREATOR == null) {
            IngredientCreatorAccess.lookupInstance(IChemicalStackIngredientCreator.class, "mekanism.common.recipe.ingredient.creator.InfusionStackIngredientCreator", helper -> {
                INFUSION_STACK_INGREDIENT_CREATOR = helper;
            });
        }
        return INFUSION_STACK_INGREDIENT_CREATOR;
    }

    public static IChemicalStackIngredientCreator<Pigment, PigmentStack, ChemicalStackIngredient.PigmentStackIngredient> pigment() {
        if (PIGMENT_STACK_INGREDIENT_CREATOR == null) {
            IngredientCreatorAccess.lookupInstance(IChemicalStackIngredientCreator.class, "mekanism.common.recipe.ingredient.creator.PigmentStackIngredientCreator", helper -> {
                PIGMENT_STACK_INGREDIENT_CREATOR = helper;
            });
        }
        return PIGMENT_STACK_INGREDIENT_CREATOR;
    }

    public static IChemicalStackIngredientCreator<Slurry, SlurryStack, ChemicalStackIngredient.SlurryStackIngredient> slurry() {
        if (SLURRY_STACK_INGREDIENT_CREATOR == null) {
            IngredientCreatorAccess.lookupInstance(IChemicalStackIngredientCreator.class, "mekanism.common.recipe.ingredient.creator.SlurryStackIngredientCreator", helper -> {
                SLURRY_STACK_INGREDIENT_CREATOR = helper;
            });
        }
        return SLURRY_STACK_INGREDIENT_CREATOR;
    }

    private static <TYPE extends IIngredientCreator<?, ?, ?>> void lookupInstance(Class<TYPE> type, String className, Consumer<TYPE> setter) {
        try {
            Class<?> clazz = Class.forName(className);
            setter.accept((IIngredientCreator)type.cast(clazz.getField("INSTANCE").get(null)));
        }
        catch (ReflectiveOperationException ex) {
            MekanismAPI.logger.fatal("Error retrieving {}, Mekanism may be absent, damaged, or outdated.", (Object)className);
        }
    }
}

