/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge.plugin;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.tick.TickReporter;
import me.lucko.spark.forge.ForgeCommandSender;
import me.lucko.spark.forge.ForgePlatformInfo;
import me.lucko.spark.forge.ForgeSparkMod;
import me.lucko.spark.forge.ForgeTickHook;
import me.lucko.spark.forge.ForgeTickReporter;
import me.lucko.spark.forge.plugin.ForgeSparkPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ForgeClientSparkPlugin
extends ForgeSparkPlugin
implements SuggestionProvider<SharedSuggestionProvider> {
    private final Minecraft minecraft;
    private CommandDispatcher<SharedSuggestionProvider> dispatcher;

    public static void register(ForgeSparkMod mod, FMLClientSetupEvent event) {
        ForgeClientSparkPlugin plugin = new ForgeClientSparkPlugin(mod, Minecraft.m_91087_());
        plugin.enable();
    }

    public ForgeClientSparkPlugin(ForgeSparkMod mod, Minecraft minecraft) {
        super(mod);
        this.minecraft = minecraft;
    }

    @Override
    public void enable() {
        super.enable();
        this.scheduler.scheduleWithFixedDelay(this::checkCommandRegistered, 10L, 10L, TimeUnit.SECONDS);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private CommandDispatcher<SharedSuggestionProvider> getPlayerCommandDispatcher() {
        return Optional.ofNullable(this.minecraft.f_91074_).map(player -> player.f_108617_).map(ClientPacketListener::m_105146_).orElse(null);
    }

    private void checkCommandRegistered() {
        CommandDispatcher<SharedSuggestionProvider> dispatcher = this.getPlayerCommandDispatcher();
        if (dispatcher == null) {
            return;
        }
        try {
            if (dispatcher != this.dispatcher) {
                this.dispatcher = dispatcher;
                ForgeClientSparkPlugin.registerCommands(this.dispatcher, context -> 1, this, "sparkc", "sparkclient");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onClientChat(ClientChatEvent event) {
        String[] args = ForgeClientSparkPlugin.processArgs(event.getMessage(), false);
        if (args == null) {
            return;
        }
        this.threadDumper.ensureSetup();
        this.platform.executeCommand(new ForgeCommandSender((CommandSource)this.minecraft.f_91074_, this), args);
        this.minecraft.f_91065_.m_93076_().m_93783_(event.getMessage());
        event.setCanceled(true);
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<SharedSuggestionProvider> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        String[] args = ForgeClientSparkPlugin.processArgs(context.getInput(), true);
        if (args == null) {
            return Suggestions.empty();
        }
        return this.generateSuggestions(new ForgeCommandSender((CommandSource)this.minecraft.f_91074_, this), args, builder);
    }

    private static String[] processArgs(String input, boolean tabComplete) {
        String[] split = input.split(" ", tabComplete ? -1 : 0);
        if (split.length == 0 || !split[0].equals("/sparkc") && !split[0].equals("/sparkclient")) {
            return null;
        }
        return Arrays.copyOfRange(split, 1, split.length);
    }

    @Override
    public boolean hasPermission(CommandSource sender, String permission) {
        return true;
    }

    public Stream<ForgeCommandSender> getCommandSenders() {
        return Stream.of(new ForgeCommandSender((CommandSource)this.minecraft.f_91074_, this));
    }

    @Override
    public TickHook createTickHook() {
        return new ForgeTickHook(TickEvent.Type.CLIENT);
    }

    @Override
    public TickReporter createTickReporter() {
        return new ForgeTickReporter(TickEvent.Type.CLIENT);
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return new ForgePlatformInfo(PlatformInfo.Type.CLIENT);
    }

    @Override
    public String getCommandName() {
        return "sparkc";
    }
}

