/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.inventory.container.machine;

import cofh.core.inventory.container.TileContainer;
import cofh.core.network.packet.server.TileConfigPacket;
import cofh.lib.block.entity.ITilePacketHandler;
import cofh.lib.inventory.container.slot.SlotCoFH;
import cofh.lib.inventory.container.slot.SlotFalseCopy;
import cofh.lib.inventory.container.slot.SlotRemoveOnly;
import cofh.lib.inventory.wrapper.InvWrapperCoFH;
import cofh.lib.util.Utils;
import cofh.thermal.expansion.block.entity.machine.MachineCrafterTile;
import cofh.thermal.expansion.init.TExpReferences;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class MachineCrafterContainer
extends TileContainer {
    public final MachineCrafterTile tile;
    private final CraftingContainer craftMatrix = new CraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final ResultContainer craftResult = new ResultContainer();
    private final Player player;
    private final boolean initialized;

    public MachineCrafterContainer(int windowId, Level level, BlockPos pos, Inventory inventory, Player player) {
        super(TExpReferences.MACHINE_CRAFTER_CONTAINER, windowId, level, pos, inventory, player);
        int i;
        this.tile = (MachineCrafterTile)level.m_7702_(pos);
        InvWrapperCoFH tileInv = new InvWrapperCoFH(this.tile.getItemInv());
        this.player = inventory.f_35978_;
        for (i = 0; i < 9; ++i) {
            this.m_38897_((Slot)new SlotCoFH(tileInv, i, 8 + i * 18, 77));
        }
        this.m_38897_((Slot)new SlotRemoveOnly((Container)tileInv, 9, 143, 21));
        this.m_38897_((Slot)new SlotCoFH(tileInv, 10, 8, 53));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_((Slot)new SlotFalseCopy((Container)this.craftMatrix, j + i * 3, 53 + j * 18, 17 + i * 18));
            }
        }
        this.m_38897_((Slot)new ResultSlot(player, this.craftMatrix, (Container)this.craftResult, 0, 114, 44){

            public boolean m_8010_(Player player) {
                return false;
            }
        });
        this.bindAugmentSlots((Container)tileInv, 21, this.tile.augSize());
        this.bindPlayerInventory(inventory);
        if (Utils.isServerWorld((Level)level)) {
            for (i = 0; i < 9; ++i) {
                this.craftMatrix.m_6836_(i, this.tile.getItemInv().get(11 + i));
            }
            this.calcCraftingGrid();
        }
        this.initialized = true;
    }

    protected int getPlayerInventoryVerticalOffset() {
        return 108;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.tile.clearRecipeChanges();
    }

    public void m_6199_(Container inventoryIn) {
        super.m_6199_(inventoryIn);
        this.slotChangedCraftingGrid();
    }

    public boolean hasValidRecipe() {
        return !this.craftResult.m_8020_(0).m_41619_();
    }

    public void setRecipe() {
        for (int i = 0; i < this.craftMatrix.m_6643_(); ++i) {
            this.tile.getItemInv().set(11 + i, this.craftMatrix.m_8020_(i));
        }
        TileConfigPacket.sendToServer((ITilePacketHandler)this.tile);
        this.tile.clearRecipeChanges();
    }

    protected void slotChangedCraftingGrid() {
        if (this.syncing || !this.initialized) {
            return;
        }
        Level level = this.tile.m_58904_();
        if (Utils.isServerWorld((Level)level)) {
            ServerPlayer playerMP = (ServerPlayer)this.player;
            ItemStack stack = ItemStack.f_41583_;
            Optional possibleRecipe = level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)this.craftMatrix, level);
            if (possibleRecipe.isPresent()) {
                stack = ((CraftingRecipe)possibleRecipe.get()).m_5874_((Container)this.craftMatrix);
                this.craftResult.m_6029_(this.craftResult.m_7928_());
            }
            this.tile.markRecipeChanges();
            this.craftResult.m_6836_(0, stack);
            playerMP.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182425_(), 20, stack));
        } else {
            this.calcCraftingGrid();
            this.tile.markRecipeChanges();
        }
    }

    protected void calcCraftingGrid() {
        Optional possibleRecipe;
        Level level = this.tile.m_58904_();
        ItemStack stack = ItemStack.f_41583_;
        if (level != null && (possibleRecipe = level.m_7465_().m_44015_(RecipeType.f_44107_, (Container)this.craftMatrix, level)).isPresent()) {
            this.craftResult.m_6029_((Recipe)possibleRecipe.get());
            stack = ((CraftingRecipe)possibleRecipe.get()).m_5874_((Container)this.craftMatrix);
        }
        this.craftResult.m_6836_(0, stack);
    }
}

