/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.block.entity.machine;

import cofh.lib.client.audio.ConditionalSound;
import cofh.lib.inventory.IItemStackAccess;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.item.SlotSealItem;
import cofh.thermal.core.util.managers.machine.SmelterRecipeManager;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.init.TExpSounds;
import cofh.thermal.expansion.inventory.container.machine.MachineSmelterContainer;
import cofh.thermal.lib.tileentity.MachineTileBase;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MachineSmelterTile
extends MachineTileBase {
    protected ItemStorageCoFH[] inputSlots = new ItemStorageCoFH[3];
    protected ItemStorageCoFH catalystSlot = new ItemStorageCoFH(item -> item.m_41720_() instanceof SlotSealItem || SmelterRecipeManager.instance().validCatalyst(item) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[0].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[1].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[2].getItemStack()));
    protected boolean cyclicProcessingFeature = false;

    public MachineSmelterTile(BlockPos pos, BlockState state) {
        super(TExpReferences.MACHINE_SMELTER_TILE, pos, state);
        this.inputSlots[0] = new ItemStorageCoFH(item -> item.m_41720_() instanceof SlotSealItem || this.filter.valid(item) && SmelterRecipeManager.instance().validItem(item) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[1].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[2].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.catalystSlot.getItemStack()));
        this.inputSlots[1] = new ItemStorageCoFH(item -> item.m_41720_() instanceof SlotSealItem || this.filter.valid(item) && SmelterRecipeManager.instance().validItem(item) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[0].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[2].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.catalystSlot.getItemStack()));
        this.inputSlots[2] = new ItemStorageCoFH(item -> item.m_41720_() instanceof SlotSealItem || this.filter.valid(item) && SmelterRecipeManager.instance().validItem(item) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[0].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.inputSlots[1].getItemStack()) && !ItemHelper.itemsEqual((ItemStack)item, (ItemStack)this.catalystSlot.getItemStack()));
        for (int i = 0; i < 3; ++i) {
            this.inventory.addSlot(this.inputSlots[i], StorageGroup.INPUT);
        }
        this.inventory.addSlot(this.catalystSlot, StorageGroup.CATALYST);
        this.inventory.addSlots(StorageGroup.OUTPUT, 4);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.addAugmentSlots(ThermalCoreConfig.machineAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return SmelterRecipeManager.instance().getBasePower();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = SmelterRecipeManager.instance().getRecipe((IThermalInventory)this);
        this.curCatalyst = SmelterRecipeManager.instance().getCatalyst((IItemStackAccess)this.catalystSlot);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    protected void resolveInputs() {
        int decrement;
        for (int i = 0; i < 3; ++i) {
            this.inputSlots[i].modify(-((Integer)this.itemInputCounts.get(i)).intValue());
        }
        if (this.cyclicProcessingFeature && !this.catalystSlot.isEmpty() && !this.catalystSlot.isFull()) {
            ItemStack catalyst = this.catalystSlot.getItemStack();
            for (ItemStorageCoFH slot : this.outputSlots()) {
                if (!ItemHelper.itemsEqualWithTags((ItemStack)slot.getItemStack(), (ItemStack)catalyst)) continue;
                slot.modify(-1);
                this.catalystSlot.modify(1);
                break;
            }
        }
        int n = decrement = this.itemInputCounts.size() > 3 ? (Integer)this.itemInputCounts.get(3) : 0;
        if (decrement > 0) {
            if (this.catalystSlot.getItemStack().m_41763_()) {
                if (this.catalystSlot.getItemStack().m_41629_(decrement, MathHelper.RANDOM, null)) {
                    this.catalystSlot.modify(-1);
                }
            } else {
                this.catalystSlot.modify(-decrement);
            }
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new MachineSmelterContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    protected Object getSound() {
        return new ConditionalSound(TExpSounds.SOUND_MACHINE_SMELTER, SoundSource.AMBIENT, (BlockEntity)this, () -> !this.f_58859_ && this.isActive);
    }

    protected boolean validateInputs() {
        if (!this.cacheRecipe()) {
            return false;
        }
        List slotInputs = this.inputSlots();
        for (int i = 0; i < slotInputs.size() && i < this.itemInputCounts.size(); ++i) {
            int inputCount = (Integer)this.itemInputCounts.get(i);
            if (((ItemStorageCoFH)slotInputs.get(i)).getItemStack().m_41613_() >= inputCount) continue;
            return false;
        }
        return true;
    }

    protected void resetAttributes() {
        super.resetAttributes();
        this.cyclicProcessingFeature = false;
    }

    protected void setAttributesFromAugment(CompoundTag augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.cyclicProcessingFeature |= AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"CycProc") > 0.0f;
    }
}

