/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.common.TileGeneric;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft")
public final class TickScheduler {
    private static final Queue<TileGeneric> toTick = new ConcurrentLinkedDeque<TileGeneric>();

    private TickScheduler() {
    }

    public static void schedule(TileGeneric tile) {
        Level world = tile.m_58904_();
        if (world != null && !world.f_46443_ && !tile.scheduled.getAndSet(true)) {
            toTick.add(tile);
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.ServerTickEvent event) {
        TileGeneric tile;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        while ((tile = toTick.poll()) != null) {
            tile.scheduled.set(false);
            if (tile.m_58901_()) continue;
            Level world = tile.m_58904_();
            BlockPos pos = tile.m_58899_();
            if (world == null || pos == null || !world.m_46749_(pos) || world.m_7702_(pos) != tile) continue;
            world.m_186460_(pos, tile.m_58900_().m_60734_(), 0);
        }
    }
}

