/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.items;

import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.ItemComputerBase;
import dan200.computercraft.shared.turtle.blocks.BlockTurtle;
import dan200.computercraft.shared.turtle.items.ITurtleItem;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;

public class ItemTurtle
extends ItemComputerBase
implements ITurtleItem {
    public static final CauldronInteraction CAULDRON_INTERACTION = (blockState, level, pos, player, hand, stack) -> {
        if (IColouredItem.getColourBasic(stack) == -1) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_) {
            IColouredItem.setColourBasic(stack, -1);
            LayeredCauldronBlock.m_153559_((BlockState)blockState, (Level)level, (BlockPos)pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    };

    public ItemTurtle(BlockTurtle block, Item.Properties settings) {
        super(block, settings);
    }

    public ItemStack create(int id, String label, int colour, ITurtleUpgrade leftUpgrade, ITurtleUpgrade rightUpgrade, int fuelLevel, ResourceLocation overlay) {
        ItemStack stack = new ItemStack((ItemLike)this);
        if (label != null) {
            stack.m_41714_((Component)new TextComponent(label));
        }
        if (id >= 0) {
            stack.m_41784_().m_128405_("ComputerId", id);
        }
        IColouredItem.setColourBasic(stack, colour);
        if (fuelLevel > 0) {
            stack.m_41784_().m_128405_("Fuel", fuelLevel);
        }
        if (overlay != null) {
            stack.m_41784_().m_128359_("Overlay", overlay.toString());
        }
        if (leftUpgrade != null) {
            stack.m_41784_().m_128359_("LeftUpgrade", leftUpgrade.getUpgradeID().toString());
        }
        if (rightUpgrade != null) {
            stack.m_41784_().m_128359_("RightUpgrade", rightUpgrade.getUpgradeID().toString());
        }
        return stack;
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> list) {
        if (!this.m_41389_(group)) {
            return;
        }
        ComputerFamily family = this.getFamily();
        list.add((Object)this.create(-1, null, -1, null, null, 0, null));
        TurtleUpgrades.getVanillaUpgrades().map(x -> this.create(-1, null, -1, null, (ITurtleUpgrade)x, 0, null)).forEach(arg_0 -> list.add(arg_0));
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        String baseString = this.m_5671_(stack);
        ITurtleUpgrade left = this.getUpgrade(stack, TurtleSide.LEFT);
        ITurtleUpgrade right = this.getUpgrade(stack, TurtleSide.RIGHT);
        if (left != null && right != null) {
            return new TranslatableComponent(baseString + ".upgraded_twice", new Object[]{new TranslatableComponent(right.getUnlocalisedAdjective()), new TranslatableComponent(left.getUnlocalisedAdjective())});
        }
        if (left != null) {
            return new TranslatableComponent(baseString + ".upgraded", new Object[]{new TranslatableComponent(left.getUnlocalisedAdjective())});
        }
        if (right != null) {
            return new TranslatableComponent(baseString + ".upgraded", new Object[]{new TranslatableComponent(right.getUnlocalisedAdjective())});
        }
        return new TranslatableComponent(baseString);
    }

    @Nullable
    public String getCreatorModId(ItemStack stack) {
        String mod;
        String mod2;
        ITurtleUpgrade left = this.getUpgrade(stack, TurtleSide.LEFT);
        if (left != null && (mod2 = TurtleUpgrades.instance().getOwner(left)) != null && !mod2.equals("computercraft")) {
            return mod2;
        }
        ITurtleUpgrade right = this.getUpgrade(stack, TurtleSide.RIGHT);
        if (right != null && (mod = TurtleUpgrades.instance().getOwner(right)) != null && !mod.equals("computercraft")) {
            return mod;
        }
        return super.getCreatorModId(stack);
    }

    @Override
    public ItemStack withFamily(@Nonnull ItemStack stack, @Nonnull ComputerFamily family) {
        return TurtleItemFactory.create(this.getComputerID(stack), this.getLabel(stack), this.getColour(stack), family, this.getUpgrade(stack, TurtleSide.LEFT), this.getUpgrade(stack, TurtleSide.RIGHT), this.getFuelLevel(stack), this.getOverlay(stack));
    }

    @Override
    public ITurtleUpgrade getUpgrade(@Nonnull ItemStack stack, @Nonnull TurtleSide side) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return null;
        }
        String key = side == TurtleSide.LEFT ? "LeftUpgrade" : "RightUpgrade";
        return tag.m_128441_(key) ? TurtleUpgrades.instance().get(tag.m_128461_(key)) : null;
    }

    @Override
    public ResourceLocation getOverlay(@Nonnull ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_("Overlay") ? new ResourceLocation(tag.m_128461_("Overlay")) : null;
    }

    @Override
    public int getFuelLevel(@Nonnull ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_("Fuel") ? tag.m_128451_("Fuel") : 0;
    }
}

