/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.OptionalInt;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.IItemHandler;

public final class TurtlePlayer
extends FakePlayer {
    private static final GameProfile DEFAULT_PROFILE = new GameProfile(UUID.fromString("0d0c4ca0-4ff1-11e4-916c-0800200c9a66"), "[ComputerCraft]");

    private TurtlePlayer(ServerLevel world, GameProfile name) {
        super(world, name);
    }

    private static TurtlePlayer create(ITurtleAccess turtle) {
        ServerPlayer actualPlayer;
        ServerLevel world = (ServerLevel)turtle.getLevel();
        GameProfile profile = turtle.getOwningPlayer();
        TurtlePlayer player = new TurtlePlayer(world, TurtlePlayer.getProfile(profile));
        player.setState(turtle);
        if (profile != null && profile.getId() != null && (actualPlayer = world.m_142572_().m_6846_().m_11259_(profile.getId())) != null) {
            player.m_8960_().m_135979_(actualPlayer);
        }
        return player;
    }

    private static GameProfile getProfile(@Nullable GameProfile profile) {
        return profile != null && profile.isComplete() ? profile : DEFAULT_PROFILE;
    }

    public static TurtlePlayer get(ITurtleAccess access) {
        if (!(access instanceof TurtleBrain)) {
            return TurtlePlayer.create(access);
        }
        TurtleBrain brain = (TurtleBrain)access;
        TurtlePlayer player = brain.cachedPlayer;
        if (player == null || player.m_36316_() != TurtlePlayer.getProfile(access.getOwningPlayer()) || player.m_20193_() != access.getLevel()) {
            player = brain.cachedPlayer = TurtlePlayer.create(brain);
        } else {
            player.setState(access);
        }
        return player;
    }

    public static TurtlePlayer getWithPosition(ITurtleAccess turtle, BlockPos position, Direction direction) {
        TurtlePlayer turtlePlayer = TurtlePlayer.get(turtle);
        turtlePlayer.setPosition(turtle, position, direction);
        return turtlePlayer;
    }

    private void setState(ITurtleAccess turtle) {
        if (this.f_36096_ != this.f_36095_) {
            ComputerCraft.log.warn("Turtle has open container ({})", (Object)this.f_36096_);
            this.m_9230_();
        }
        BlockPos position = turtle.getPosition();
        this.m_20343_((double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.5, (double)position.m_123343_() + 0.5);
        this.m_19915_(turtle.getDirection().m_122435_(), 0.0f);
        this.m_150109_().m_6211_();
    }

    public void setPosition(ITurtleAccess turtle, BlockPos position, Direction direction) {
        double posX = (double)position.m_123341_() + 0.5;
        double posY = (double)position.m_123342_() + 0.5;
        double posZ = (double)position.m_123343_() + 0.5;
        if (turtle.getPosition().equals((Object)position)) {
            posX += 0.48 * (double)direction.m_122429_();
            posY += 0.48 * (double)direction.m_122430_();
            posZ += 0.48 * (double)direction.m_122431_();
        }
        if (direction.m_122434_() != Direction.Axis.Y) {
            this.m_19915_(direction.m_122435_(), 0.0f);
        } else {
            this.m_19915_(turtle.getDirection().m_122435_(), DirectionUtil.toPitchAngle(direction));
        }
        this.m_20343_(posX, posY, posZ);
        this.f_19854_ = posX;
        this.f_19855_ = posY;
        this.f_19856_ = posZ;
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.f_20886_ = this.f_20885_ = this.m_146908_();
    }

    public void loadInventory(@Nonnull ItemStack stack) {
        this.m_150109_().m_6211_();
        this.m_150109_().f_35977_ = 0;
        this.m_150109_().m_6836_(0, stack);
    }

    public void loadInventory(@Nonnull ITurtleAccess turtle) {
        this.m_150109_().m_6211_();
        int currentSlot = turtle.getSelectedSlot();
        int slots = turtle.getItemHandler().getSlots();
        this.m_150109_().f_35977_ = 0;
        for (int i = 0; i < slots; ++i) {
            this.m_150109_().m_6836_(i, turtle.getItemHandler().getStackInSlot((currentSlot + i) % slots));
        }
    }

    public void unloadInventory(ITurtleAccess turtle) {
        int currentSlot = turtle.getSelectedSlot();
        int slots = turtle.getItemHandler().getSlots();
        this.m_150109_().f_35977_ = 0;
        for (int i = 0; i < slots; ++i) {
            turtle.getItemHandler().setStackInSlot((currentSlot + i) % slots, this.m_150109_().m_8020_(i));
        }
        BlockPos dropPosition = turtle.getPosition();
        Direction dropDirection = turtle.getDirection().m_122424_();
        int totalSize = this.m_150109_().m_6643_();
        for (int i = slots; i < totalSize; ++i) {
            ItemStack remainder = InventoryUtil.storeItems(this.m_150109_().m_8020_(i), (IItemHandler)turtle.getItemHandler(), turtle.getSelectedSlot());
            if (remainder.m_41619_()) continue;
            WorldUtil.dropItemStack(remainder, turtle.getLevel(), dropPosition, dropDirection);
        }
        this.m_150109_().m_6596_();
    }

    public Vec3 m_20182_() {
        return new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public float m_20236_(@Nonnull Pose pose) {
        return 0.0f;
    }

    public float m_6431_(@Nonnull Pose pose, @Nonnull EntityDimensions size) {
        return 0.0f;
    }

    @Nonnull
    public OptionalInt m_5893_(@Nullable MenuProvider prover) {
        return OptionalInt.empty();
    }

    public void m_8108_() {
    }

    public void m_8098_() {
    }

    public boolean m_7998_(@Nonnull Entity entityIn, boolean force) {
        return false;
    }

    public void m_8127_() {
    }

    public void m_7739_(@Nonnull SignBlockEntity signTile) {
    }

    public void m_6658_(@Nonnull AbstractHorse horse, @Nonnull Container inventory) {
    }

    public void m_6986_(@Nonnull ItemStack stack, @Nonnull InteractionHand hand) {
    }

    public void m_6915_() {
    }

    protected void m_7285_(@Nonnull MobEffectInstance effect) {
    }
}

