/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.TurtlePermissions;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BottleItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.WaterLilyBlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class TurtlePlaceCommand
implements ITurtleCommand {
    private final InteractDirection direction;
    private final Object[] extraArguments;

    public TurtlePlaceCommand(InteractDirection direction, Object[] arguments) {
        this.direction = direction;
        this.extraArguments = arguments;
    }

    @Override
    @Nonnull
    public TurtleCommandResult execute(@Nonnull ITurtleAccess turtle) {
        ItemStack stack = turtle.getInventory().m_8020_(turtle.getSelectedSlot());
        if (stack.m_41619_()) {
            return TurtleCommandResult.failure("No items to place");
        }
        Direction direction = this.direction.toWorldDir(turtle);
        BlockPos coordinates = turtle.getPosition().m_142300_(direction);
        BlockPos playerPosition = turtle.getPosition().m_142300_(direction);
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, playerPosition, direction);
        turtlePlayer.loadInventory(turtle);
        ErrorMessage message = new ErrorMessage();
        boolean result = TurtlePlaceCommand.deploy(stack, turtle, turtlePlayer, direction, this.extraArguments, message);
        turtlePlayer.unloadInventory(turtle);
        if (result) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        if (message.message != null) {
            return TurtleCommandResult.failure(message.message);
        }
        return TurtleCommandResult.failure(stack.m_41720_() instanceof BlockItem ? "Cannot place block here" : "Cannot place item here");
    }

    public static boolean deployCopiedItem(@Nonnull ItemStack stack, ITurtleAccess turtle, Direction direction, Object[] extraArguments, ErrorMessage outErrorMessage) {
        BlockPos playerPosition = turtle.getPosition().m_142300_(direction);
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, playerPosition, direction);
        turtlePlayer.loadInventory(stack);
        boolean result = TurtlePlaceCommand.deploy(stack, turtle, turtlePlayer, direction, extraArguments, outErrorMessage);
        turtlePlayer.m_150109_().m_6211_();
        return result;
    }

    private static boolean deploy(@Nonnull ItemStack stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer, Direction direction, Object[] extraArguments, ErrorMessage outErrorMessage) {
        if (TurtlePlaceCommand.deployOnEntity(stack, turtle, turtlePlayer)) {
            return true;
        }
        BlockPos position = turtle.getPosition();
        BlockPos newPosition = position.m_142300_(direction);
        return TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition, direction.m_122424_(), extraArguments, true, outErrorMessage) || TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition.m_142300_(direction), direction.m_122424_(), extraArguments, false, outErrorMessage) || direction.m_122434_() != Direction.Axis.Y && TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, newPosition.m_7495_(), Direction.UP, extraArguments, false, outErrorMessage) || TurtlePlaceCommand.deployOnBlock(stack, turtle, turtlePlayer, position, direction, extraArguments, false, outErrorMessage);
    }

    private static boolean deployOnEntity(@Nonnull ItemStack stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer) {
        Vec3 rayDir;
        Level world = turtle.getLevel();
        BlockPos position = turtle.getPosition();
        Vec3 turtlePos = turtlePlayer.m_20182_();
        Pair<Entity, Vec3> hit = WorldUtil.rayTraceEntities(world, turtlePos, rayDir = turtlePlayer.m_20252_(1.0f), 1.5);
        if (hit == null) {
            return false;
        }
        Entity hitEntity = (Entity)hit.getKey();
        Vec3 hitPos = (Vec3)hit.getValue();
        InvWrapper itemHandler = new InvWrapper((Container)turtlePlayer.m_150109_());
        DropConsumer.set(hitEntity, arg_0 -> TurtlePlaceCommand.lambda$deployOnEntity$0((IItemHandler)itemHandler, arg_0));
        boolean placed = TurtlePlaceCommand.doDeployOnEntity(stack, turtlePlayer, hitEntity, hitPos);
        DropConsumer.clearAndDrop(world, position, turtle.getDirection().m_122424_());
        return placed;
    }

    private static boolean doDeployOnEntity(@Nonnull ItemStack stack, TurtlePlayer turtlePlayer, @Nonnull Entity hitEntity, @Nonnull Vec3 hitPos) {
        InteractionResult interactAt = ForgeHooks.onInteractEntityAt((Player)turtlePlayer, (Entity)hitEntity, (Vec3)hitPos, (InteractionHand)InteractionHand.MAIN_HAND);
        if (interactAt == null) {
            interactAt = hitEntity.m_7111_((Player)turtlePlayer, hitPos, InteractionHand.MAIN_HAND);
        }
        if (interactAt.m_19077_()) {
            return true;
        }
        InteractionResult interact = ForgeHooks.onInteractEntity((Player)turtlePlayer, (Entity)hitEntity, (InteractionHand)InteractionHand.MAIN_HAND);
        if (interact != null) {
            return interact.m_19077_();
        }
        if (hitEntity.m_6096_((Player)turtlePlayer, InteractionHand.MAIN_HAND).m_19077_()) {
            return true;
        }
        if (hitEntity instanceof LivingEntity) {
            LivingEntity hitLiving = (LivingEntity)hitEntity;
            return stack.m_41647_((Player)turtlePlayer, hitLiving, InteractionHand.MAIN_HAND).m_19077_();
        }
        return false;
    }

    private static boolean canDeployOnBlock(@Nonnull BlockPlaceContext context, ITurtleAccess turtle, TurtlePlayer player, BlockPos position, Direction side, boolean allowReplaceable, ErrorMessage outErrorMessage) {
        Level world = turtle.getLevel();
        if (!world.m_46739_(position) || world.m_46859_(position) || context.m_43722_().m_41720_() instanceof BlockItem && WorldUtil.isLiquidBlock(world, position)) {
            return false;
        }
        BlockState state = world.m_8055_(position);
        boolean replaceable = state.m_60629_(context);
        if (!allowReplaceable && replaceable) {
            return false;
        }
        if (ComputerCraft.turtlesObeyBlockProtection) {
            boolean editable;
            boolean bl = editable = replaceable ? TurtlePermissions.isBlockEditable(world, position, (Player)player) : TurtlePermissions.isBlockEditable(world, position.m_142300_(side), (Player)player);
            if (!editable) {
                if (outErrorMessage != null) {
                    outErrorMessage.message = "Cannot place in protected area";
                }
                return false;
            }
        }
        return true;
    }

    private static boolean deployOnBlock(@Nonnull ItemStack stack, ITurtleAccess turtle, TurtlePlayer turtlePlayer, BlockPos position, Direction side, Object[] extraArguments, boolean allowReplace, ErrorMessage outErrorMessage) {
        Object object;
        BlockHitResult hit;
        UseOnContext context;
        Direction playerDir = side.m_122424_();
        BlockPos playerPosition = position.m_142300_(side);
        turtlePlayer.setPosition(turtle, playerPosition, playerDir);
        float hitX = 0.5f + (float)side.m_122429_() * 0.5f;
        float hitY = 0.5f + (float)side.m_122430_() * 0.5f;
        float hitZ = 0.5f + (float)side.m_122431_() * 0.5f;
        if (Math.abs(hitY - 0.5f) < 0.01f) {
            hitY = 0.45f;
        }
        if (!TurtlePlaceCommand.canDeployOnBlock(new BlockPlaceContext(context = new UseOnContext((Player)turtlePlayer, InteractionHand.MAIN_HAND, hit = new BlockHitResult(new Vec3((double)hitX, (double)hitY, (double)hitZ), side, position, false))), turtle, turtlePlayer, position, side, allowReplace, outErrorMessage)) {
            return false;
        }
        Item item = stack.m_41720_();
        BlockEntity existingTile = turtle.getLevel().m_7702_(position);
        boolean placed = TurtlePlaceCommand.doDeployOnBlock(stack, turtlePlayer, position, context, hit).m_19077_();
        if (placed && item instanceof SignItem && extraArguments != null && extraArguments.length >= 1 && (object = extraArguments[0]) instanceof String) {
            String message = (String)object;
            Level world = turtle.getLevel();
            BlockEntity tile = world.m_7702_(position);
            if (tile == null || tile == existingTile) {
                tile = world.m_7702_(position.m_142300_(side));
            }
            if (tile instanceof SignBlockEntity) {
                TurtlePlaceCommand.setSignText(world, tile, message);
            }
        }
        return placed;
    }

    private static InteractionResult doDeployOnBlock(@Nonnull ItemStack stack, TurtlePlayer turtlePlayer, BlockPos position, UseOnContext context, BlockHitResult hit) {
        InteractionResult result;
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((Player)turtlePlayer, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)position, (BlockHitResult)hit);
        if (event.isCanceled()) {
            return event.getCancellationResult();
        }
        if (event.getUseItem() != Event.Result.DENY && (result = stack.onItemUseFirst(context)) != InteractionResult.PASS) {
            return result;
        }
        if (event.getUseItem() != Event.Result.DENY && (result = stack.m_41661_(context)) != InteractionResult.PASS) {
            return result;
        }
        Item item = stack.m_41720_();
        if (item instanceof BucketItem || item instanceof BoatItem || item instanceof WaterLilyBlockItem || item instanceof BottleItem) {
            InteractionResult actionResult = ForgeHooks.onItemRightClick((Player)turtlePlayer, (InteractionHand)InteractionHand.MAIN_HAND);
            if (actionResult != null && actionResult != InteractionResult.PASS) {
                return actionResult;
            }
            InteractionResultHolder result2 = stack.m_41682_(context.m_43725_(), (Player)turtlePlayer, InteractionHand.MAIN_HAND);
            if (result2.m_19089_().m_19077_() && !ItemStack.m_41728_((ItemStack)stack, (ItemStack)((ItemStack)result2.m_19095_()))) {
                turtlePlayer.m_21008_(InteractionHand.MAIN_HAND, (ItemStack)result2.m_19095_());
                return result2.m_19089_();
            }
        }
        return InteractionResult.PASS;
    }

    private static void setSignText(Level world, BlockEntity tile, String message) {
        SignBlockEntity signTile = (SignBlockEntity)tile;
        String[] split = message.split("\n");
        int firstLine = split.length <= 2 ? 1 : 0;
        for (int i = 0; i < 4; ++i) {
            if (i >= firstLine && i < firstLine + split.length) {
                String line = split[i - firstLine];
                signTile.m_59732_(i, (Component)(line.length() > 15 ? new TextComponent(line.substring(0, 15)) : new TextComponent(line)));
                continue;
            }
            signTile.m_59732_(i, (Component)new TextComponent(""));
        }
        signTile.m_6596_();
        world.m_7260_(tile.m_58899_(), tile.m_58900_(), tile.m_58900_(), 3);
    }

    private static /* synthetic */ ItemStack lambda$deployOnEntity$0(IItemHandler itemHandler, ItemStack drop) {
        return InventoryUtil.storeItems(drop, itemHandler, 1);
    }

    private static class ErrorMessage {
        String message;

        private ErrorMessage() {
        }
    }
}

