/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.asm;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.LuaTable;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.objectweb.asm.MethodVisitor;

final class Reflect {
    static final Type OPTIONAL_IN = Optional.class.getTypeParameters()[0];

    private Reflect() {
    }

    @Nullable
    static String getLuaName(Class<?> klass, boolean unsafe) {
        if (klass.isPrimitive()) {
            if (klass == Integer.TYPE) {
                return "Int";
            }
            if (klass == Boolean.TYPE) {
                return "Boolean";
            }
            if (klass == Double.TYPE) {
                return "Double";
            }
            if (klass == Long.TYPE) {
                return "Long";
            }
        } else {
            if (klass == Map.class) {
                return "Table";
            }
            if (klass == String.class) {
                return "String";
            }
            if (klass == ByteBuffer.class) {
                return "Bytes";
            }
            if (klass == LuaTable.class && unsafe) {
                return "TableUnsafe";
            }
        }
        return null;
    }

    @Nullable
    static Class<?> getRawType(Method method, Type root, boolean allowParameter) {
        Type underlying = root;
        while (true) {
            if (underlying instanceof Class) {
                return (Class)underlying;
            }
            if (!(underlying instanceof ParameterizedType)) break;
            ParameterizedType type = (ParameterizedType)underlying;
            if (!allowParameter) {
                for (Type arg : type.getActualTypeArguments()) {
                    if (arg instanceof WildcardType || arg instanceof TypeVariable && ((TypeVariable)arg).getName().startsWith("capture#")) continue;
                    ComputerCraft.log.error("Method {}.{} has generic type {} with non-wildcard argument {}.", new Object[]{method.getDeclaringClass(), method.getName(), root, arg});
                    return null;
                }
            }
            underlying = type.getRawType();
        }
        ComputerCraft.log.error("Method {}.{} has unknown generic type {}.", new Object[]{method.getDeclaringClass(), method.getName(), root});
        return null;
    }

    static void loadInt(MethodVisitor visitor, int value) {
        if (value >= -1 && value <= 5) {
            visitor.visitInsn(3 + value);
        } else {
            visitor.visitLdcInsn((Object)value);
        }
    }
}

