/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render.text;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.Palette;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;

public final class FixedWidthFontRenderer {
    public static final ResourceLocation FONT = new ResourceLocation("computercraft", "textures/gui/term_font.png");
    public static final int FONT_HEIGHT = 9;
    public static final int FONT_WIDTH = 6;
    static final float WIDTH = 256.0f;
    static final float BACKGROUND_START = 0.9765625f;
    static final float BACKGROUND_END = 0.984375f;
    private static final byte[] BLACK = new byte[]{FixedWidthFontRenderer.byteColour(Colour.BLACK.getR()), FixedWidthFontRenderer.byteColour(Colour.BLACK.getR()), FixedWidthFontRenderer.byteColour(Colour.BLACK.getR()), -1};

    private FixedWidthFontRenderer() {
    }

    private static byte byteColour(float c) {
        return (byte)(c * 255.0f);
    }

    public static float toGreyscale(double[] rgb) {
        return (float)((rgb[0] + rgb[1] + rgb[2]) / 3.0);
    }

    public static int getColour(char c, Colour def) {
        return 15 - Terminal.getColour(c, def);
    }

    private static void drawChar(QuadEmitter emitter, float x, float y, int index, byte[] colour, int light) {
        if (index == 0 || index == 32) {
            return;
        }
        int column = index % 16;
        int row = index / 16;
        int xStart = 1 + column * 8;
        int yStart = 1 + row * 11;
        FixedWidthFontRenderer.quad(emitter, x, y, x + 6.0f, y + 9.0f, 0.0f, colour, (float)xStart / 256.0f, (float)yStart / 256.0f, (float)(xStart + 6) / 256.0f, (float)(yStart + 9) / 256.0f, light);
    }

    public static void drawQuad(QuadEmitter emitter, float x, float y, float z, float width, float height, byte[] colour, int light) {
        FixedWidthFontRenderer.quad(emitter, x, y, x + width, y + height, z, colour, 0.9765625f, 0.9765625f, 0.984375f, 0.984375f, light);
    }

    private static void drawQuad(QuadEmitter emitter, float x, float y, float width, float height, Palette palette, boolean greyscale, char colourIndex, int light) {
        byte[] colour = palette.getByteColour(FixedWidthFontRenderer.getColour(colourIndex, Colour.BLACK), greyscale);
        FixedWidthFontRenderer.drawQuad(emitter, x, y, 0.0f, width, height, colour, light);
    }

    private static void drawBackground(@Nonnull QuadEmitter emitter, float x, float y, @Nonnull TextBuffer backgroundColour, @Nonnull Palette palette, boolean greyscale, float leftMarginSize, float rightMarginSize, float height, int light) {
        if (leftMarginSize > 0.0f) {
            FixedWidthFontRenderer.drawQuad(emitter, x - leftMarginSize, y, leftMarginSize, height, palette, greyscale, backgroundColour.charAt(0), light);
        }
        if (rightMarginSize > 0.0f) {
            FixedWidthFontRenderer.drawQuad(emitter, x + (float)(backgroundColour.length() * 6), y, rightMarginSize, height, palette, greyscale, backgroundColour.charAt(backgroundColour.length() - 1), light);
        }
        int blockStart = 0;
        char blockColour = '\u0000';
        for (int i = 0; i < backgroundColour.length(); ++i) {
            char colourIndex = backgroundColour.charAt(i);
            if (colourIndex == blockColour) continue;
            if (blockColour != '\u0000') {
                FixedWidthFontRenderer.drawQuad(emitter, x + (float)(blockStart * 6), y, 6 * (i - blockStart), height, palette, greyscale, blockColour, light);
            }
            blockColour = colourIndex;
            blockStart = i;
        }
        if (blockColour != '\u0000') {
            FixedWidthFontRenderer.drawQuad(emitter, x + (float)(blockStart * 6), y, 6 * (backgroundColour.length() - blockStart), height, palette, greyscale, blockColour, light);
        }
    }

    public static void drawString(@Nonnull QuadEmitter emitter, float x, float y, @Nonnull TextBuffer text, @Nonnull TextBuffer textColour, @Nonnull Palette palette, boolean greyscale, int light) {
        for (int i = 0; i < text.length(); ++i) {
            byte[] colour = palette.getByteColour(FixedWidthFontRenderer.getColour(textColour.charAt(i), Colour.BLACK), greyscale);
            int index = text.charAt(i);
            if (index > 255) {
                index = 63;
            }
            FixedWidthFontRenderer.drawChar(emitter, x + (float)(i * 6), y, index, colour, light);
        }
    }

    public static void drawTerminalWithoutCursor(@Nonnull QuadEmitter emitter, float x, float y, @Nonnull Terminal terminal, boolean greyscale, float topMarginSize, float bottomMarginSize, float leftMarginSize, float rightMarginSize) {
        Palette palette = terminal.getPalette();
        int height = terminal.getHeight();
        FixedWidthFontRenderer.drawBackground(emitter, x, y - topMarginSize, terminal.getBackgroundColourLine(0), palette, greyscale, leftMarginSize, rightMarginSize, topMarginSize, 0xF000F0);
        FixedWidthFontRenderer.drawBackground(emitter, x, y + (float)(height * 9), terminal.getBackgroundColourLine(height - 1), palette, greyscale, leftMarginSize, rightMarginSize, bottomMarginSize, 0xF000F0);
        for (int i = 0; i < height; ++i) {
            float rowY = y + (float)(9 * i);
            FixedWidthFontRenderer.drawBackground(emitter, x, rowY, terminal.getBackgroundColourLine(i), palette, greyscale, leftMarginSize, rightMarginSize, 9.0f, 0xF000F0);
            FixedWidthFontRenderer.drawString(emitter, x, rowY, terminal.getLine(i), terminal.getTextColourLine(i), palette, greyscale, 0xF000F0);
        }
    }

    public static boolean isCursorVisible(Terminal terminal) {
        if (!terminal.getCursorBlink()) {
            return false;
        }
        int cursorX = terminal.getCursorX();
        int cursorY = terminal.getCursorY();
        return cursorX >= 0 && cursorX < terminal.getWidth() && cursorY >= 0 && cursorY < terminal.getHeight();
    }

    public static void drawCursor(@Nonnull QuadEmitter emitter, float x, float y, @Nonnull Terminal terminal, boolean greyscale) {
        if (FixedWidthFontRenderer.isCursorVisible(terminal) && FrameInfo.getGlobalCursorBlink()) {
            byte[] colour = terminal.getPalette().getByteColour(15 - terminal.getTextColour(), greyscale);
            FixedWidthFontRenderer.drawChar(emitter, x + (float)(terminal.getCursorX() * 6), y + (float)(terminal.getCursorY() * 9), 95, colour, 0xF000F0);
        }
    }

    public static void drawTerminal(@Nonnull QuadEmitter emitter, float x, float y, @Nonnull Terminal terminal, boolean greyscale, float topMarginSize, float bottomMarginSize, float leftMarginSize, float rightMarginSize) {
        FixedWidthFontRenderer.drawTerminalWithoutCursor(emitter, x, y, terminal, greyscale, topMarginSize, bottomMarginSize, leftMarginSize, rightMarginSize);
        FixedWidthFontRenderer.drawCursor(emitter, x, y, terminal, greyscale);
    }

    public static void drawEmptyTerminal(@Nonnull QuadEmitter emitter, float x, float y, float width, float height) {
        FixedWidthFontRenderer.drawQuad(emitter, x, y, 0.0f, width, height, BLACK, 0xF000F0);
    }

    public static void drawBlocker(@Nonnull QuadEmitter emitter, float x, float y, float width, float height) {
        FixedWidthFontRenderer.drawQuad(emitter, x, y, 0.0f, width, height, BLACK, 0xF000F0);
    }

    public static QuadEmitter toVertexConsumer(Matrix4f matrix, VertexConsumer consumer) {
        return new QuadEmitter(matrix, consumer);
    }

    private static void quad(QuadEmitter c, float x1, float y1, float x2, float y2, float z, byte[] rgba, float u1, float v1, float u2, float v2, int light) {
        Matrix4f matrix = c.matrix4f();
        VertexConsumer consumer = c.consumer();
        byte r = rgba[0];
        byte g = rgba[1];
        byte b = rgba[2];
        byte a = rgba[3];
        consumer.m_85982_(matrix, x1, y1, z).m_6122_((int)r, (int)g, (int)b, (int)a).m_7421_(u1, v1).m_85969_(light).m_5752_();
        consumer.m_85982_(matrix, x1, y2, z).m_6122_((int)r, (int)g, (int)b, (int)a).m_7421_(u1, v2).m_85969_(light).m_5752_();
        consumer.m_85982_(matrix, x2, y2, z).m_6122_((int)r, (int)g, (int)b, (int)a).m_7421_(u2, v2).m_85969_(light).m_5752_();
        consumer.m_85982_(matrix, x2, y1, z).m_6122_((int)r, (int)g, (int)b, (int)a).m_7421_(u2, v1).m_85969_(light).m_5752_();
    }

    public record QuadEmitter(Matrix4f matrix4f, VertexConsumer consumer) {
    }
}

