/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.peripheral;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PeripheralType {
    private static final PeripheralType UNTYPED = new PeripheralType(null, Collections.emptySet());
    private final String type;
    private final Set<String> additionalTypes;

    public PeripheralType(String type, Set<String> additionalTypes) {
        this.type = type;
        this.additionalTypes = additionalTypes;
        if (additionalTypes.contains(null)) {
            throw new IllegalArgumentException("All additional types must be non-null");
        }
    }

    public static PeripheralType untyped() {
        return UNTYPED;
    }

    public static PeripheralType ofType(@Nonnull String type) {
        if (Strings.isNullOrEmpty((String)type)) {
            throw new IllegalArgumentException("type cannot be null or empty");
        }
        return new PeripheralType(type, Collections.emptySet());
    }

    public static PeripheralType ofType(@Nonnull String type, Collection<String> additionalTypes) {
        if (Strings.isNullOrEmpty((String)type)) {
            throw new IllegalArgumentException("type cannot be null or empty");
        }
        return new PeripheralType(type, (Set<String>)ImmutableSet.copyOf(additionalTypes));
    }

    public static PeripheralType ofType(@Nonnull String type, String ... additionalTypes) {
        if (Strings.isNullOrEmpty((String)type)) {
            throw new IllegalArgumentException("type cannot be null or empty");
        }
        return new PeripheralType(type, (Set<String>)ImmutableSet.copyOf((Object[])additionalTypes));
    }

    public static PeripheralType ofAdditional(Collection<String> additionalTypes) {
        return new PeripheralType(null, (Set<String>)ImmutableSet.copyOf(additionalTypes));
    }

    public static PeripheralType ofAdditional(String ... additionalTypes) {
        return new PeripheralType(null, (Set<String>)ImmutableSet.copyOf((Object[])additionalTypes));
    }

    @Nullable
    public String getPrimaryType() {
        return this.type;
    }

    public Set<String> getAdditionalTypes() {
        return this.additionalTypes;
    }
}

