/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.lib.doubles;

import cc.tweaked.internal.cobalt.lib.doubles.Assert;
import cc.tweaked.internal.cobalt.lib.doubles.UnsignedValues;
import java.math.BigInteger;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.checker.signedness.qual.Unsigned;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;

public class Bignum {
    private static final @UnknownVal @Signed long LONG_SIGN_BIT = Long.MIN_VALUE;
    private static final @UnknownVal @Signed long LONG_UNSIGNED_BITS = Long.MAX_VALUE;
    private static final @UnknownVal @UnknownSignedness BigInteger INT_MASK = BigInteger.valueOf(0xFFFFFFFFL);
    private static final @UnknownVal @UnknownSignedness BigInteger NOT_INT_MASK = INT_MASK.not();
    private @UnknownVal @UnknownSignedness BigInteger val;

    public Bignum() {
        this.val = BigInteger.ZERO;
    }

    private Bignum(@UnknownVal @UnknownSignedness BigInteger val) {
        this.val = val;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownVal @UnknownSignedness boolean equals(@UnknownVal @UnknownSignedness Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bignum bignum = (Bignum)o;
        return this.val.equals(bignum.val);
    }

    @Pure
    public @UnknownVal @Signed int hashCode() {
        return Objects.hash(this.val);
    }

    @UnknownVal @UnknownSignedness String toHexString() {
        return this.val.toString(16).toUpperCase();
    }

    public @UnknownVal @UnknownSignedness Bignum copy() {
        return new Bignum(this.val);
    }

    public void assignHexString(@UnknownVal @UnknownSignedness String value) {
        this.val = new BigInteger(value, 16);
    }

    public void assignDecimalString(@UnknownVal @UnknownSignedness String value) {
        this.val = new BigInteger(value);
    }

    public void assignUInt(@Unsigned @UnknownVal short unsignedValue) {
        this.val = Bignum.fromUnsigned(unsignedValue);
    }

    public void assignUInt(@Unsigned @UnknownVal int unsignedValue) {
        this.val = Bignum.fromUnsigned(unsignedValue);
    }

    public void assignUInt(@Unsigned @UnknownVal long unsignedValue) {
        this.val = Bignum.fromUnsigned(unsignedValue);
    }

    public void assignUInt16(@Unsigned @UnknownVal short unsignedValue) {
        this.assignUInt(unsignedValue);
    }

    public void assignUInt32(@Unsigned @UnknownVal int unsignedValue) {
        this.assignUInt(unsignedValue);
    }

    public void assignUInt64(@Unsigned @UnknownVal long unsignedValue) {
        this.assignUInt(unsignedValue);
    }

    public void assignBignum(@UnknownVal @UnknownSignedness Bignum other) {
        this.val = other.val;
    }

    public void assignPowerUInt16(@UnknownVal @Signed int base, @UnknownVal @Signed int exponent) {
        this.assignPower(base, exponent);
    }

    public void assignPower(@UnknownVal @Signed int base, @UnknownVal @Signed int exponent) {
        this.val = BigInteger.valueOf(base).pow(exponent);
    }

    public void addUInt64(@Unsigned @UnknownVal long operand) {
        this.add(Bignum.fromUnsigned(operand));
    }

    private void add(@UnknownVal @UnknownSignedness BigInteger operand) {
        this.val = this.val.add(operand);
    }

    public void addBignum(@UnknownVal @UnknownSignedness Bignum other) {
        this.val = this.val.add(other.val);
    }

    public void subtractBignum(@UnknownVal @UnknownSignedness Bignum other) {
        this.val = this.val.subtract(other.val);
    }

    public void square() {
        this.val = this.val.multiply(this.val);
    }

    public void shiftLeft(@UnknownVal @Signed int shiftAmount) {
        this.val = this.val.shiftLeft(shiftAmount);
    }

    public void multiplyByUInt32(@Unsigned @UnknownVal int unsignedFactor) {
        this.multiply(Bignum.fromUnsigned(unsignedFactor));
    }

    void multiplyByUInt64(@Unsigned @UnknownVal long unsignedFactor) {
        this.multiply(Bignum.fromUnsigned(unsignedFactor));
    }

    void multiplyByPowerOfTen(@UnknownVal @Signed int exponent) {
        this.val = this.val.multiply(BigInteger.valueOf(10L).pow(exponent));
    }

    private void multiply(@UnknownVal @UnknownSignedness BigInteger exponent) {
        this.val = this.val.multiply(exponent);
    }

    void times10() {
        this.multiplyByUInt32(10);
    }

    @Unsigned @UnknownVal int divideModuloIntBignum(@UnknownVal @UnknownSignedness Bignum other) {
        Assert.requireState(this.val.signum() >= 0 && other.val.signum() >= 0, "values must be positive");
        BigInteger[] rets = this.val.divideAndRemainder(other.val);
        this.val = rets[1];
        return UnsignedValues.toUint(rets[0]);
    }

    static @UnknownVal @Signed int compare(@UnknownVal @UnknownSignedness Bignum a, @UnknownVal @UnknownSignedness Bignum b) {
        return a.val.compareTo(b.val);
    }

    static @UnknownVal @UnknownSignedness boolean equal(@UnknownVal @UnknownSignedness Bignum a, @UnknownVal @UnknownSignedness Bignum b) {
        return Bignum.compare(a, b) == 0;
    }

    static @UnknownVal @UnknownSignedness boolean lessEqual(@UnknownVal @UnknownSignedness Bignum a, @UnknownVal @UnknownSignedness Bignum b) {
        return Bignum.compare(a, b) <= 0;
    }

    static @UnknownVal @UnknownSignedness boolean less(@UnknownVal @UnknownSignedness Bignum a, @UnknownVal @UnknownSignedness Bignum b) {
        return Bignum.compare(a, b) < 0;
    }

    static @UnknownVal @Signed int plusCompare(@UnknownVal @UnknownSignedness Bignum a, @UnknownVal @UnknownSignedness Bignum b, @UnknownVal @UnknownSignedness Bignum c) {
        return a.val.add(b.val).compareTo(c.val);
    }

    static @UnknownVal @UnknownSignedness boolean plusEqual(@UnknownVal @UnknownSignedness Bignum a, @UnknownVal @UnknownSignedness Bignum b, @UnknownVal @UnknownSignedness Bignum c) {
        return Bignum.plusCompare(a, b, c) == 0;
    }

    static @UnknownVal @UnknownSignedness boolean plusLessEqual(@UnknownVal @UnknownSignedness Bignum a, @UnknownVal @UnknownSignedness Bignum b, @UnknownVal @UnknownSignedness Bignum c) {
        return Bignum.plusCompare(a, b, c) <= 0;
    }

    static @UnknownVal @UnknownSignedness boolean plusLess(@UnknownVal @UnknownSignedness Bignum a, @UnknownVal @UnknownSignedness Bignum b, @UnknownVal @UnknownSignedness Bignum c) {
        return Bignum.plusCompare(a, b, c) < 0;
    }

    private static @UnknownVal @UnknownSignedness BigInteger fromUnsigned(@Unsigned @UnknownVal short value) {
        return BigInteger.valueOf(Short.toUnsignedLong(value));
    }

    private static @UnknownVal @UnknownSignedness BigInteger fromUnsigned(@Unsigned @UnknownVal int value) {
        return BigInteger.valueOf(Integer.toUnsignedLong(value));
    }

    private static @UnknownVal @UnknownSignedness BigInteger fromUnsigned(@Unsigned @UnknownVal long value) {
        if ((value & Long.MIN_VALUE) != 0L) {
            return BigInteger.valueOf(value & Long.MAX_VALUE).add(BigInteger.valueOf(1L).shiftLeft(63));
        }
        return BigInteger.valueOf(value);
    }
}

