/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.itshallnottick.mixin;

import dev.wuffs.itshallnottick.Config;
import dev.wuffs.itshallnottick.Utils;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkGenerator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NaturalSpawner.class})
public class WorldEntitySpawnerOptimizationMixin {
    @Inject(at={@At(value="HEAD")}, method={"getRandomSpawnMobAt"}, cancellable=true)
    private static void getRandomSpawnMobAt(ServerLevel level, StructureFeatureManager arg2, ChunkGenerator arg3, MobCategory arg4, Random random, BlockPos blockPos, CallbackInfoReturnable<Optional<MobSpawnSettings.SpawnerData>> cir) {
        int maxDistanceSquare;
        int maxHeight;
        if (!Utils.isInClaimedChunk((Level)level, blockPos) && Utils.enoughPlayers((Level)level) && !Utils.isNearPlayer((Level)level, blockPos, maxHeight = ((Integer)Config.maxEntitySpawnDistanceVertical.get()).intValue(), maxDistanceSquare = ((Integer)Config.maxEntitySpawnDistanceHorizontal.get()).intValue())) {
            cir.setReturnValue(Optional.empty());
        }
    }
}

