/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.itshallnottick;

import dev.wuffs.itshallnottick.ItShallNotTick;
import dev.wuffs.itshallnottick.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    public static final String CATEGORY_GENERAL = "general";
    public static ForgeConfigSpec CONFIG;
    public static ForgeConfigSpec.ConfigValue<Integer> maxEntitySpawnDistanceHorizontal;
    public static ForgeConfigSpec.ConfigValue<Integer> maxEntitySpawnDistanceVertical;
    public static ForgeConfigSpec.ConfigValue<Integer> maxEntityTickDistanceHorizontal;
    public static ForgeConfigSpec.ConfigValue<Integer> maxEntityTickDistanceVertical;
    public static ForgeConfigSpec.ConfigValue<List<String>> entityIgnoreList;
    public static ForgeConfigSpec.ConfigValue<Integer> minPlayers;
    public static final Set<ResourceLocation> entityResources;
    public static final Set<TagKey<EntityType<?>>> entityTagKeys;
    public static final Set<String> entityWildcards;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Config.updateMobLists();
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Config.updateMobLists();
    }

    private static void updateMobLists() {
        Utils.isIgnored.clear();
        for (String key : (List)entityIgnoreList.get()) {
            if (key.contains("#")) {
                entityTagKeys.add(TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)new ResourceLocation(key.replace("#", ""))));
                continue;
            }
            if (key.contains("*")) {
                entityWildcards.add(key.split(":")[0]);
                continue;
            }
            entityResources.add(new ResourceLocation(key));
        }
        ItShallNotTick.LOGGER.debug(entityResources);
        ItShallNotTick.LOGGER.debug(entityTagKeys);
        ItShallNotTick.LOGGER.debug(entityWildcards);
    }

    static {
        entityResources = new HashSet<ResourceLocation>();
        entityTagKeys = new HashSet();
        entityWildcards = new HashSet<String>();
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        ArrayList<String> defaultIgnoreList = new ArrayList<String>();
        defaultIgnoreList.add("minecraft:wither");
        defaultIgnoreList.add("minecraft:phantom");
        defaultIgnoreList.add("minecraft:ender_dragon");
        defaultIgnoreList.add("minecraft:elder_guardian");
        defaultIgnoreList.add("minecraft:player");
        BUILDER.comment("General settings").push(CATEGORY_GENERAL);
        maxEntitySpawnDistanceHorizontal = BUILDER.comment("Maximum distance from player (horizontally) for entity spawning check [Squared, Default 64^2]").define("maxEntitySpawnDistanceHorizontal", (Object)4096);
        maxEntitySpawnDistanceVertical = BUILDER.comment("Maximum distance from player (vertically) for entity spawning check [Raw, Default 32]").define("maxEntitySpawnDistanceVertical", (Object)32);
        maxEntityTickDistanceHorizontal = BUILDER.comment("Maximum distance from player (horizontally) to allow entity ticking [Squared, Default 48^2]").define("maxEntityTickDistanceHorizontal", (Object)2304);
        maxEntityTickDistanceVertical = BUILDER.comment("Maximum distance from player (vertically) to allow entity ticking [Raw, Default 32]").define("maxEntityTickDistanceVertical", (Object)32);
        entityIgnoreList = BUILDER.comment(new String[]{"List of entities to ignore when checking if they are allowed to tick", "Tags can be used by using #minecraft:<tag_name> or #modid:<tag_name>", "You can also use a wildcard after modid (modid:*)", "Example list for a modpack", "entityIgnoreList = [\"minecraft:wither\",\"minecraft:phantom\",\"minecraft:ender_dragon\", \"minecraft:elder_guardian\", \"minecraft:player\", \"botania:*\", \"create:*\", \"ftbic:*\", \"immersiveengineering:*\", \"ae2:*\", \"littlelogistics:*\", \"tiab:*\"]"}).define("entityIgnoreList", defaultIgnoreList);
        minPlayers = BUILDER.comment("Minimum number of players before mod is enabled").define("minPlayers", (Object)2);
        BUILDER.pop();
        CONFIG = BUILDER.build();
    }
}

