/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.systems.worldgen;

import com.sammy.ortus.helpers.BlockHelper;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;

public class OrtusBlockFiller {
    public ArrayList<BlockStateEntry> entries = new ArrayList();
    public final boolean careful;

    public OrtusBlockFiller(boolean careful) {
        this.careful = careful;
    }

    public void fill(WorldGenLevel level) {
        for (BlockStateEntry entry : this.entries) {
            if (this.careful && !entry.canPlace(level)) continue;
            entry.place(level);
        }
    }

    public void replaceAt(int index, BlockStateEntry entry) {
        this.entries.set(index, entry);
    }

    public static class BlockStateEntry {
        public final BlockState state;
        public final BlockPos pos;

        public BlockStateEntry(BlockState state, BlockPos pos) {
            this.state = state;
            this.pos = pos;
        }

        public boolean canPlace(WorldGenLevel level) {
            return this.canPlace(level, this.pos);
        }

        public boolean canPlace(WorldGenLevel level, BlockPos pos) {
            if (level.m_151570_(pos)) {
                return false;
            }
            BlockState state = level.m_8055_(pos);
            return level.m_46859_(pos) || state.m_60767_().m_76336_();
        }

        public void place(WorldGenLevel level) {
            level.m_7731_(this.pos, this.state, 19);
            if (level instanceof Level) {
                BlockHelper.updateState((Level)level, this.pos);
            }
        }
    }
}

