/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.systems.textureloader;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import com.sammy.ortus.helpers.ColorHelper;
import com.sammy.ortus.systems.easing.Easing;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.Mth;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class OrtusTextureLoader {
    private static final ColorLerp GRADIENT = (image, x, y, luminosity) -> (float)(y % 16) / 16.0f;
    private static final ColorLerp LUMINOUS_GRADIENT = (image, x, y, luminosity) -> ((float)(y % 16) / 16.0f + (float)luminosity / 255.0f) / 2.0f;
    private static final ColorLerp LUMINOUS = (image, x, y, luminosity) -> (float)luminosity / 255.0f;

    public static void setup() {
    }

    public static void copyTextureWithChanges(ResourceLocation loaderName, ResourceLocation targetPath, ResourceLocation sourcePath, TextureModifier modifier) {
        IEventBus busMod = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForgeClient.registerTextureAtlasSpriteLoader((ResourceLocation)loaderName, (atlas, resourceManager, textureInfo, resource, atlasWidth, atlasHeight, spriteX, spriteY, mipmapLevel, image) -> {
            Resource r = null;
            try {
                r = resourceManager.m_142591_(sourcePath);
                image = modifier.modifyTexture(NativeImage.m_85058_((InputStream)r.m_6679_()));
            }
            catch (Throwable throwable1) {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (Throwable throwable) {
                        throwable1.addSuppressed(throwable);
                    }
                }
                throwable1.printStackTrace();
            }
            TextureAtlasSprite.Info info = null;
            if (r != null) {
                try {
                    AnimationMetadataSection section = (AnimationMetadataSection)r.m_5507_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_);
                    if (section == null) {
                        section = AnimationMetadataSection.f_119012_;
                    }
                    Pair pair = section.m_7117_(image.m_84982_(), image.m_85084_());
                    info = new TextureAtlasSprite.Info(textureInfo.m_118431_(), ((Integer)pair.getFirst()).intValue(), ((Integer)pair.getSecond()).intValue(), section);
                    r.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return new TextureAtlasSprite(atlas, info == null ? textureInfo : info, mipmapLevel, atlasWidth, atlasHeight, spriteX, spriteY, image){};
        });
        busMod.addListener(event -> event.addSprite(targetPath));
    }

    public static NativeImage grayscale(NativeImage nativeimage) {
        for (int x = 0; x < nativeimage.m_84982_(); ++x) {
            for (int y = 0; y < nativeimage.m_85084_(); ++y) {
                int pixel = nativeimage.m_84985_(x, y);
                int L = (int)(0.299 * (double)(pixel & 0xFF) + 0.587 * (double)(pixel >> 8 & 0xFF) + 0.114 * (double)(pixel >> 16 & 0xFF));
                nativeimage.m_84988_(x, y, NativeImage.m_84992_((int)(pixel >> 24 & 0xFF), (int)L, (int)L, (int)L));
            }
        }
        return nativeimage;
    }

    public static NativeImage multiColorGradient(NativeImage nativeimage, ColorLerp colorLerp, Color ... colors) {
        int colorCount = colors.length - 1;
        for (int x = 0; x < nativeimage.m_84982_(); ++x) {
            for (int y = 0; y < nativeimage.m_85084_(); ++y) {
                int pixel = nativeimage.m_84985_(x, y);
                int luminosity = (int)(0.299 * (double)(pixel & 0xFF) + 0.587 * (double)(pixel >> 8 & 0xFF) + 0.114 * (double)(pixel >> 16 & 0xFF));
                float lerp = 1.0f - colorLerp.lerp(pixel, x, y, luminosity);
                float colorIndex = (float)colorCount * lerp;
                int index = (int)Mth.m_14036_((float)colorIndex, (float)0.0f, (float)colorCount);
                Color color = colors[index];
                Color nextColor = index == colorCount ? color : colors[index + 1];
                Color transition = ColorHelper.colorLerp(Easing.LINEAR, colorIndex - (float)((int)colorIndex), nextColor, color);
                nativeimage.m_84988_(x, y, NativeImage.m_84992_((int)(pixel >> 24 & 0xFF), (int)transition.getBlue(), (int)transition.getGreen(), (int)transition.getRed()));
            }
        }
        return nativeimage;
    }

    public static interface TextureModifier {
        public NativeImage modifyTexture(NativeImage var1);
    }

    public static interface ColorLerp {
        public float lerp(int var1, int var2, int var3, int var4);
    }
}

