/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.systems.screenshake;

import com.mojang.math.Vector3f;
import com.sammy.ortus.systems.screenshake.ScreenshakeInstance;
import net.minecraft.client.Camera;
import net.minecraft.world.phys.Vec3;

public class PositionedScreenshakeInstance
extends ScreenshakeInstance {
    public Vec3 position;
    public float falloffDistance;
    public float maxDistance;

    public PositionedScreenshakeInstance(Vec3 position, float falloffDistance, float maxDistance, float intensity, float falloffTransformSpeed, int timeBeforeFastFalloff, float slowFalloff, float fastFalloff) {
        super(intensity, falloffTransformSpeed, timeBeforeFastFalloff, slowFalloff, fastFalloff);
        this.position = position;
        this.falloffDistance = falloffDistance;
        this.maxDistance = maxDistance;
    }

    @Override
    public float updateIntensity(Camera camera, float falloff) {
        Vec3 directionToScreenshake;
        Vector3f lookDirection;
        float angle;
        float intensity = super.updateIntensity(camera, falloff);
        float distance = (float)this.position.m_82554_(camera.m_90583_());
        if (distance > this.maxDistance) {
            return 0.0f;
        }
        float distanceMultiplier = 1.0f;
        if (distance > this.falloffDistance) {
            float remaining = this.maxDistance - this.falloffDistance;
            float current = distance - this.falloffDistance;
            distanceMultiplier = 1.0f - current / remaining;
        }
        if ((angle = (lookDirection = camera.m_90596_()).m_122276_(new Vector3f(directionToScreenshake = this.position.m_82546_(camera.m_90583_()).m_82541_()))) < 0.0f) {
            return 0.0f;
        }
        return intensity * distanceMultiplier * angle;
    }
}

