/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.systems.rendering.particle.screen.base;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.sammy.ortus.systems.rendering.particle.screen.base.ScreenParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class QuadScreenParticle
extends ScreenParticle {
    protected float quadSize;

    protected QuadScreenParticle(ClientLevel pLevel, double pX, double pY) {
        super(pLevel, pX, pY);
        this.quadSize = 0.1f * (this.random.nextFloat() * 0.5f + 0.5f) * 2.0f;
    }

    protected QuadScreenParticle(ClientLevel pLevel, double pX, double pY, double pXSpeed, double pYSpeed) {
        super(pLevel, pX, pY, pXSpeed, pYSpeed);
        this.quadSize = 0.1f * (this.random.nextFloat() * 0.5f + 0.5f) * 2.0f;
    }

    @Override
    public void render(BufferBuilder bufferBuilder) {
        float partialTicks = Minecraft.m_91087_().f_90991_.f_92518_;
        float size = this.getQuadSize(partialTicks) * 10.0f;
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        float roll = Mth.m_14179_((float)partialTicks, (float)this.oRoll, (float)this.roll);
        Vector3f[] vectors = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        Quaternion rotation = Vector3f.f_122227_.m_122270_(roll);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = vectors[i];
            vector3f.m_122251_(rotation);
            vector3f.m_122261_(size);
            vector3f.m_122272_((float)this.x, (float)this.y, 0.0f);
        }
        int z = 390;
        bufferBuilder.m_5483_((double)vectors[0].m_122239_(), (double)vectors[0].m_122260_(), (double)z).m_7421_(u1, v1).m_85950_(this.rCol, this.gCol, this.bCol, this.alpha).m_85969_(0xF000F0).m_5752_();
        bufferBuilder.m_5483_((double)vectors[1].m_122239_(), (double)vectors[1].m_122260_(), (double)z).m_7421_(u1, v0).m_85950_(this.rCol, this.gCol, this.bCol, this.alpha).m_85969_(0xF000F0).m_5752_();
        bufferBuilder.m_5483_((double)vectors[2].m_122239_(), (double)vectors[2].m_122260_(), (double)z).m_7421_(u0, v0).m_85950_(this.rCol, this.gCol, this.bCol, this.alpha).m_85969_(0xF000F0).m_5752_();
        bufferBuilder.m_5483_((double)vectors[3].m_122239_(), (double)vectors[3].m_122260_(), (double)z).m_7421_(u0, v1).m_85950_(this.rCol, this.gCol, this.bCol, this.alpha).m_85969_(0xF000F0).m_5752_();
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize;
    }

    protected abstract float getU0();

    protected abstract float getU1();

    protected abstract float getV0();

    protected abstract float getV1();
}

