/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.systems.rendering.particle.screen;

import com.sammy.ortus.handlers.ScreenParticleHandler;
import com.sammy.ortus.systems.rendering.particle.SimpleParticleOptions;
import com.sammy.ortus.systems.rendering.particle.screen.ScreenParticleOptions;
import com.sammy.ortus.systems.rendering.particle.screen.base.TextureSheetScreenParticle;
import java.awt.Color;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class GenericScreenParticle
extends TextureSheetScreenParticle {
    public ScreenParticleOptions data;
    private final ParticleRenderType renderType;
    protected final ParticleEngine.MutableSpriteSet spriteSet;
    float[] hsv1 = new float[3];
    float[] hsv2 = new float[3];

    public GenericScreenParticle(ClientLevel world, ScreenParticleOptions data, ParticleEngine.MutableSpriteSet spriteSet, double x, double y, double xMotion, double yMotion) {
        super(world, x, y);
        this.data = data;
        this.renderType = data.renderType;
        this.spriteSet = spriteSet;
        this.roll = data.spinOffset + data.spin1;
        if (!data.forcedMotion) {
            this.xMotion = xMotion;
            this.yMotion = yMotion;
        }
        this.setRenderOrder(data.renderOrder);
        this.setLifetime(data.lifetime);
        this.gravity = data.gravity ? 1.0f : 0.0f;
        this.friction = 1.0f;
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, data.r1)), (int)(255.0f * Math.min(1.0f, data.g1)), (int)(255.0f * Math.min(1.0f, data.b1)), this.hsv1);
        Color.RGBtoHSB((int)(255.0f * Math.min(1.0f, data.r2)), (int)(255.0f * Math.min(1.0f, data.g2)), (int)(255.0f * Math.min(1.0f, data.b2)), this.hsv2);
        this.updateTraits();
        if (this.getAnimator().equals((Object)SimpleParticleOptions.Animator.RANDOM_SPRITE)) {
            this.pickSprite((SpriteSet)spriteSet);
        }
        if (this.getAnimator().equals((Object)SimpleParticleOptions.Animator.FIRST_INDEX) || this.getAnimator().equals((Object)SimpleParticleOptions.Animator.WITH_AGE)) {
            this.pickSprite(0);
        }
        if (this.getAnimator().equals((Object)SimpleParticleOptions.Animator.LAST_INDEX)) {
            this.pickSprite(spriteSet.f_107406_.size() - 1);
        }
        this.updateTraits();
    }

    public SimpleParticleOptions.Animator getAnimator() {
        return this.data.animator;
    }

    public void pickSprite(int spriteIndex) {
        if (spriteIndex < this.spriteSet.f_107406_.size() && spriteIndex >= 0) {
            this.setSprite((TextureAtlasSprite)this.spriteSet.f_107406_.get(spriteIndex));
        }
    }

    public void pickColor(float colorCoeff) {
        float h = Mth.m_14189_((float)colorCoeff, (float)(360.0f * this.hsv1[0]), (float)(360.0f * this.hsv2[0])) / 360.0f;
        float s = Mth.m_14179_((float)colorCoeff, (float)this.hsv1[1], (float)this.hsv2[1]);
        float v = Mth.m_14179_((float)colorCoeff, (float)this.hsv1[2], (float)this.hsv2[2]);
        int packed = Color.HSBtoRGB(h, s, v);
        float r = (float)FastColor.ARGB32.m_13665_((int)packed) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)packed) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)packed) / 255.0f;
        this.setColor(r, g, b);
    }

    public float getCurve(float multiplier) {
        return Mth.m_14036_((float)((float)this.age * multiplier / (float)this.lifetime), (float)0.0f, (float)1.0f);
    }

    protected void updateTraits() {
        float trinaryAge;
        this.pickColor(this.data.colorCurveEasing.ease(this.getCurve(this.data.colorCurveMultiplier), 0.0f, 1.0f, 1.0f));
        this.quadSize = this.data.isTrinaryScale() ? ((trinaryAge = this.getCurve(this.data.scaleCurveMultiplier)) >= 0.5f ? Mth.m_14179_((float)this.data.scaleCurveEndEasing.ease(trinaryAge - 0.5f, 0.0f, 1.0f, 0.5f), (float)this.data.scale2, (float)this.data.scale3) : Mth.m_14179_((float)this.data.scaleCurveStartEasing.ease(trinaryAge, 0.0f, 1.0f, 0.5f), (float)this.data.scale1, (float)this.data.scale2)) : Mth.m_14179_((float)this.data.scaleCurveStartEasing.ease(this.getCurve(this.data.scaleCurveMultiplier), 0.0f, 1.0f, 1.0f), (float)this.data.scale1, (float)this.data.scale2);
        this.alpha = this.data.isTrinaryAlpha() ? ((trinaryAge = this.getCurve(this.data.alphaCurveMultiplier)) >= 0.5f ? Mth.m_14179_((float)this.data.alphaCurveStartEasing.ease(trinaryAge - 0.5f, 0.0f, 1.0f, 0.5f), (float)this.data.alpha2, (float)this.data.alpha3) : Mth.m_14179_((float)this.data.alphaCurveStartEasing.ease(trinaryAge, 0.0f, 1.0f, 0.5f), (float)this.data.alpha1, (float)this.data.alpha2)) : Mth.m_14179_((float)this.data.alphaCurveStartEasing.ease(this.getCurve(this.data.alphaCurveMultiplier), 0.0f, 1.0f, 1.0f), (float)this.data.alpha1, (float)this.data.alpha2);
        this.oRoll = this.roll;
        this.roll += Mth.m_14179_((float)this.data.spinEasing.ease(this.getCurve(this.data.spinCurveMultiplier), 0.0f, 1.0f, 1.0f), (float)this.data.spin1, (float)this.data.spin2);
        if (this.data.forcedMotion) {
            float motionAge = this.getCurve(this.data.motionCurveMultiplier);
            this.xMotion = Mth.m_14179_((float)this.data.motionEasing.ease(motionAge, 0.0f, 1.0f, 1.0f), (float)this.data.startingMotion.m_122239_(), (float)this.data.endingMotion.m_122239_());
            this.yMotion = Mth.m_14179_((float)this.data.motionEasing.ease(motionAge, 0.0f, 1.0f, 1.0f), (float)this.data.startingMotion.m_122260_(), (float)this.data.endingMotion.m_122260_());
        } else {
            this.xMotion *= (double)this.data.motionCurveMultiplier;
            this.yMotion *= (double)this.data.motionCurveMultiplier;
        }
    }

    @Override
    public void tick() {
        this.updateTraits();
        if (this.data.animator.equals((Object)SimpleParticleOptions.Animator.WITH_AGE)) {
            this.setSpriteFromAge((SpriteSet)this.spriteSet);
        }
        super.tick();
    }

    public void trackStack() {
        for (ScreenParticleHandler.StackTracker renderedStack : ScreenParticleHandler.RENDERED_STACKS) {
            if (!renderedStack.stack().equals(this.data.stack) || !renderedStack.order().equals((Object)this.data.renderOrder)) continue;
            this.x = (double)(renderedStack.xOrigin() + this.data.xOffset) + this.xMoved;
            this.y = (double)(renderedStack.yOrigin() + this.data.yOffset) + this.yMoved;
            break;
        }
    }

    @Override
    public ParticleRenderType getRenderType() {
        return this.renderType;
    }
}

