/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.systems.rendering.particle;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import com.sammy.ortus.handlers.ScreenParticleHandler;
import com.sammy.ortus.systems.easing.Easing;
import com.sammy.ortus.systems.rendering.particle.SimpleParticleOptions;
import com.sammy.ortus.systems.rendering.particle.screen.ScreenParticleOptions;
import com.sammy.ortus.systems.rendering.particle.screen.ScreenParticleType;
import com.sammy.ortus.systems.rendering.particle.screen.base.ScreenParticle;
import com.sammy.ortus.systems.rendering.particle.world.WorldParticleOptions;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;

public class ParticleBuilders {
    public static WorldParticleBuilder create(ParticleType<?> type) {
        return new WorldParticleBuilder(type);
    }

    public static WorldParticleBuilder create(RegistryObject<?> type) {
        return new WorldParticleBuilder((ParticleType)type.get());
    }

    public static ScreenParticleBuilder create(ScreenParticleType<?> type) {
        return new ScreenParticleBuilder(type);
    }

    public static class WorldParticleBuilder {
        static Random random = new Random();
        ParticleType<?> type;
        WorldParticleOptions data;
        double vx = 0.0;
        double vy = 0.0;
        double vz = 0.0;
        double dx = 0.0;
        double dy = 0.0;
        double dz = 0.0;
        double maxXSpeed = 0.0;
        double maxYSpeed = 0.0;
        double maxZSpeed = 0.0;
        double maxXDist = 0.0;
        double maxYDist = 0.0;
        double maxZDist = 0.0;

        protected WorldParticleBuilder(ParticleType<?> type) {
            this.type = type;
            this.data = new WorldParticleOptions(type);
        }

        public WorldParticleBuilder overwriteAnimator(SimpleParticleOptions.Animator animator) {
            this.data.animator = animator;
            return this;
        }

        public WorldParticleBuilder overwriteRenderType(ParticleRenderType renderType) {
            this.data.renderType = renderType;
            return this;
        }

        public WorldParticleBuilder setColorEasing(Easing easing) {
            this.data.colorCurveEasing = easing;
            return this;
        }

        public WorldParticleBuilder setColorCurveMultiplier(float colorCurveMultiplier) {
            this.data.colorCurveMultiplier = colorCurveMultiplier;
            return this;
        }

        public WorldParticleBuilder setColor(float r, float g, float b) {
            return this.setColor(r, g, b, this.data.alpha1, r, g, b, this.data.alpha2);
        }

        public WorldParticleBuilder setColor(float r, float g, float b, float a) {
            return this.setColor(r, g, b, a, r, g, b, a);
        }

        public WorldParticleBuilder setColor(float r, float g, float b, float a1, float a2) {
            return this.setColor(r, g, b, a1, r, g, b, a2);
        }

        public WorldParticleBuilder setColor(float r1, float g1, float b1, float r2, float g2, float b2) {
            return this.setColor(r1, g1, b1, this.data.alpha1, r2, g2, b2, this.data.alpha2);
        }

        public WorldParticleBuilder setColor(float r1, float g1, float b1, float r2, float g2, float b2, float a) {
            return this.setColor(r1, g1, b1, a, r2, g2, b2, a);
        }

        public WorldParticleBuilder setColor(float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2) {
            this.data.r1 = r1;
            this.data.g1 = g1;
            this.data.b1 = b1;
            this.data.alpha1 = a1;
            this.data.r2 = r2;
            this.data.g2 = g2;
            this.data.b2 = b2;
            this.data.alpha2 = a2;
            return this;
        }

        public WorldParticleBuilder setColor(Color c1, Color c2) {
            this.data.r1 = (float)c1.getRed() / 255.0f;
            this.data.g1 = (float)c1.getGreen() / 255.0f;
            this.data.b1 = (float)c1.getBlue() / 255.0f;
            this.data.r2 = (float)c2.getRed() / 255.0f;
            this.data.g2 = (float)c2.getGreen() / 255.0f;
            this.data.b2 = (float)c2.getBlue() / 255.0f;
            return this;
        }

        public WorldParticleBuilder setAlphaEasing(Easing startEasing, Easing endEasing) {
            this.data.alphaCurveStartEasing = startEasing;
            this.data.alphaCurveEndEasing = endEasing;
            return this;
        }

        public WorldParticleBuilder setAlphaEasing(Easing easing) {
            this.data.alphaCurveStartEasing = easing;
            return this;
        }

        public WorldParticleBuilder setAlphaCurveMultiplier(float alphaCurveMultiplier) {
            this.data.alphaCurveMultiplier = alphaCurveMultiplier;
            return this;
        }

        public WorldParticleBuilder setAlpha(float alpha) {
            return this.setAlpha(alpha, alpha);
        }

        public WorldParticleBuilder setAlpha(float alpha1, float alpha2) {
            return this.setAlpha(alpha1, alpha2, alpha2);
        }

        public WorldParticleBuilder setAlpha(float alpha1, float alpha2, float alpha3) {
            this.data.alpha1 = alpha1;
            this.data.alpha2 = alpha2;
            this.data.alpha3 = alpha3;
            return this;
        }

        public WorldParticleBuilder setScaleEasing(Easing startEasing, Easing endEasing) {
            this.data.scaleCurveStartEasing = startEasing;
            this.data.scaleCurveEndEasing = endEasing;
            return this;
        }

        public WorldParticleBuilder setScaleEasing(Easing easing) {
            this.data.scaleCurveStartEasing = easing;
            return this;
        }

        public WorldParticleBuilder setScaleCurveMultiplier(float scaleCurveMultiplier) {
            this.data.scaleCurveMultiplier = scaleCurveMultiplier;
            return this;
        }

        public WorldParticleBuilder setScale(float scale) {
            return this.setScale(scale, scale);
        }

        public WorldParticleBuilder setScale(float scale1, float scale2) {
            return this.setScale(scale1, scale2, scale2);
        }

        public WorldParticleBuilder setScale(float scale1, float scale2, float scale3) {
            this.data.scale1 = scale1;
            this.data.scale2 = scale2;
            this.data.scale3 = scale3;
            return this;
        }

        public WorldParticleBuilder enableGravity() {
            this.data.gravity = true;
            return this;
        }

        public WorldParticleBuilder disableGravity() {
            this.data.gravity = false;
            return this;
        }

        public WorldParticleBuilder enableNoClip() {
            this.data.noClip = true;
            return this;
        }

        public WorldParticleBuilder disableNoClip() {
            this.data.noClip = false;
            return this;
        }

        public WorldParticleBuilder setSpinEasing(Easing easing) {
            this.data.spinEasing = easing;
            return this;
        }

        public WorldParticleBuilder setSpinCurveMultiplier(float spinCurveMultiplier) {
            this.data.spinCurveMultiplier = spinCurveMultiplier;
            return this;
        }

        public WorldParticleBuilder setSpinOffset(float spinOffset) {
            this.data.spinOffset = spinOffset;
            return this;
        }

        public WorldParticleBuilder setSpin(float spin) {
            return this.setSpin(spin, spin);
        }

        public WorldParticleBuilder setSpin(float spin1, float spin2) {
            this.data.spin1 = spin1;
            this.data.spin2 = spin2;
            return this;
        }

        public WorldParticleBuilder setLifetime(int lifetime) {
            this.data.lifetime = lifetime;
            return this;
        }

        public WorldParticleBuilder randomMotion(double maxSpeed) {
            return this.randomMotion(maxSpeed, maxSpeed, maxSpeed);
        }

        public WorldParticleBuilder randomMotion(double maxHSpeed, double maxVSpeed) {
            return this.randomMotion(maxHSpeed, maxVSpeed, maxHSpeed);
        }

        public WorldParticleBuilder randomMotion(double maxXSpeed, double maxYSpeed, double maxZSpeed) {
            this.maxXSpeed = maxXSpeed;
            this.maxYSpeed = maxYSpeed;
            this.maxZSpeed = maxZSpeed;
            return this;
        }

        public WorldParticleBuilder addMotion(double vx, double vy, double vz) {
            this.vx += vx;
            this.vy += vy;
            this.vz += vz;
            return this;
        }

        public WorldParticleBuilder setMotion(double vx, double vy, double vz) {
            this.vx = vx;
            this.vy = vy;
            this.vz = vz;
            return this;
        }

        public WorldParticleBuilder setForcedMotion(Vector3f startingMotion, Vector3f endingMotion) {
            this.data.forcedMotion = true;
            this.data.startingMotion = startingMotion;
            this.data.endingMotion = endingMotion;
            return this;
        }

        public WorldParticleBuilder disableForcedMotion() {
            this.data.forcedMotion = false;
            return this;
        }

        public WorldParticleBuilder randomOffset(double maxDistance) {
            return this.randomOffset(maxDistance, maxDistance, maxDistance);
        }

        public WorldParticleBuilder randomOffset(double maxHDist, double maxVDist) {
            return this.randomOffset(maxHDist, maxVDist, maxHDist);
        }

        public WorldParticleBuilder randomOffset(double maxXDist, double maxYDist, double maxZDist) {
            this.maxXDist = maxXDist;
            this.maxYDist = maxYDist;
            this.maxZDist = maxZDist;
            return this;
        }

        public WorldParticleBuilder spawnCircle(Level level, double x, double y, double z, double distance, double currentCount, double totalCount) {
            double xSpeed = (double)random.nextFloat() * this.maxXSpeed;
            double ySpeed = (double)random.nextFloat() * this.maxYSpeed;
            double zSpeed = (double)random.nextFloat() * this.maxZSpeed;
            double theta = Math.PI * 2 / totalCount;
            double finalAngle = currentCount / totalCount + theta * currentCount;
            double dx2 = distance * Math.cos(finalAngle);
            double dz2 = distance * Math.sin(finalAngle);
            Vector3d vector2f = new Vector3d(dx2, 0.0, dz2);
            this.vx = vector2f.f_86214_ * xSpeed;
            this.vz = vector2f.f_86216_ * zSpeed;
            double yaw2 = (double)random.nextFloat() * Math.PI * 2.0;
            double pitch2 = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
            double xDist = (double)random.nextFloat() * this.maxXDist;
            double yDist = (double)random.nextFloat() * this.maxYDist;
            double zDist = (double)random.nextFloat() * this.maxZDist;
            this.dx = Math.sin(yaw2) * Math.cos(pitch2) * xDist;
            this.dy = Math.sin(pitch2) * yDist;
            this.dz = Math.cos(yaw2) * Math.cos(pitch2) * zDist;
            level.m_7106_((ParticleOptions)this.data, x + this.dx + dx2, y + this.dy, z + this.dz + dz2, this.vx, ySpeed, this.vz);
            return this;
        }

        public WorldParticleBuilder spawn(Level level, double x, double y, double z) {
            double yaw = (double)random.nextFloat() * Math.PI * 2.0;
            double pitch = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
            double xSpeed = (double)random.nextFloat() * this.maxXSpeed;
            double ySpeed = (double)random.nextFloat() * this.maxYSpeed;
            double zSpeed = (double)random.nextFloat() * this.maxZSpeed;
            this.vx += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
            this.vy += Math.sin(pitch) * ySpeed;
            this.vz += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
            double yaw2 = (double)random.nextFloat() * Math.PI * 2.0;
            double pitch2 = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
            double xDist = (double)random.nextFloat() * this.maxXDist;
            double yDist = (double)random.nextFloat() * this.maxYDist;
            double zDist = (double)random.nextFloat() * this.maxZDist;
            this.dx = Math.sin(yaw2) * Math.cos(pitch2) * xDist;
            this.dy = Math.sin(pitch2) * yDist;
            this.dz = Math.cos(yaw2) * Math.cos(pitch2) * zDist;
            level.m_7106_((ParticleOptions)this.data, x + this.dx, y + this.dy, z + this.dz, this.vx, this.vy, this.vz);
            return this;
        }

        public WorldParticleBuilder evenlySpawnAtEdges(Level level, BlockPos pos) {
            for (Direction direction : Direction.values()) {
                double yaw = (double)random.nextFloat() * Math.PI * 2.0;
                double pitch = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
                double xSpeed = (double)random.nextFloat() * this.maxXSpeed;
                double ySpeed = (double)random.nextFloat() * this.maxYSpeed;
                double zSpeed = (double)random.nextFloat() * this.maxZSpeed;
                this.vx += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
                this.vy += Math.sin(pitch) * ySpeed;
                this.vz += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
                Direction.Axis direction$axis = direction.m_122434_();
                double d0 = 0.5625;
                this.dx = direction$axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.m_122429_() : (double)random.nextFloat();
                this.dy = direction$axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.m_122430_() : (double)random.nextFloat();
                this.dz = direction$axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.m_122431_() : (double)random.nextFloat();
                level.m_7106_((ParticleOptions)this.data, (double)pos.m_123341_() + this.dx, (double)pos.m_123342_() + this.dy, (double)pos.m_123343_() + this.dz, this.vx, this.vy, this.vz);
            }
            return this;
        }

        public WorldParticleBuilder evenlySpawnAtEdges(Level level, BlockPos pos, Direction ... directions) {
            for (Direction direction : directions) {
                double yaw = (double)random.nextFloat() * Math.PI * 2.0;
                double pitch = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
                double xSpeed = (double)random.nextFloat() * this.maxXSpeed;
                double ySpeed = (double)random.nextFloat() * this.maxYSpeed;
                double zSpeed = (double)random.nextFloat() * this.maxZSpeed;
                this.vx += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
                this.vy += Math.sin(pitch) * ySpeed;
                this.vz += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
                Direction.Axis direction$axis = direction.m_122434_();
                double d0 = 0.5625;
                this.dx = direction$axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.m_122429_() : (double)random.nextFloat();
                this.dy = direction$axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.m_122430_() : (double)random.nextFloat();
                this.dz = direction$axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.m_122431_() : (double)random.nextFloat();
                level.m_7106_((ParticleOptions)this.data, (double)pos.m_123341_() + this.dx, (double)pos.m_123342_() + this.dy, (double)pos.m_123343_() + this.dz, this.vx, this.vy, this.vz);
            }
            return this;
        }

        public WorldParticleBuilder spawnAtEdges(Level level, BlockPos pos) {
            Direction direction = Direction.values()[level.f_46441_.nextInt(Direction.values().length)];
            double yaw = (double)random.nextFloat() * Math.PI * 2.0;
            double pitch = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
            double xSpeed = (double)random.nextFloat() * this.maxXSpeed;
            double ySpeed = (double)random.nextFloat() * this.maxYSpeed;
            double zSpeed = (double)random.nextFloat() * this.maxZSpeed;
            this.vx += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
            this.vy += Math.sin(pitch) * ySpeed;
            this.vz += Math.cos(yaw) * Math.cos(pitch) * zSpeed;
            Direction.Axis direction$axis = direction.m_122434_();
            double d0 = 0.5625;
            this.dx = direction$axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.m_122429_() : (double)random.nextFloat();
            this.dy = direction$axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.m_122430_() : (double)random.nextFloat();
            this.dz = direction$axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.m_122431_() : (double)random.nextFloat();
            level.m_7106_((ParticleOptions)this.data, (double)pos.m_123341_() + this.dx, (double)pos.m_123342_() + this.dy, (double)pos.m_123343_() + this.dz, this.vx, this.vy, this.vz);
            return this;
        }

        public WorldParticleBuilder repeat(Level level, double x, double y, double z, int n) {
            for (int i = 0; i < n; ++i) {
                this.spawn(level, x, y, z);
            }
            return this;
        }

        public WorldParticleBuilder repeatEdges(Level level, BlockPos pos, int n) {
            for (int i = 0; i < n; ++i) {
                this.spawnAtEdges(level, pos);
            }
            return this;
        }

        public WorldParticleBuilder evenlyRepeatEdges(Level level, BlockPos pos, int n) {
            for (int i = 0; i < n; ++i) {
                this.evenlySpawnAtEdges(level, pos);
            }
            return this;
        }

        public WorldParticleBuilder evenlyRepeatEdges(Level level, BlockPos pos, int n, Direction ... directions) {
            for (int i = 0; i < n; ++i) {
                this.evenlySpawnAtEdges(level, pos, directions);
            }
            return this;
        }

        public WorldParticleBuilder repeatCircle(Level level, double x, double y, double z, double distance, int times) {
            for (int i = 0; i < times; ++i) {
                this.spawnCircle(level, x, y, z, distance, i, times);
            }
            return this;
        }
    }

    public static class ScreenParticleBuilder {
        static Random random = new Random();
        ScreenParticleType<?> type;
        ScreenParticleOptions data;
        double vx = 0.0;
        double vy = 0.0;
        double dx = 0.0;
        double dy = 0.0;
        double maxXSpeed = 0.0;
        double maxYSpeed = 0.0;
        double maxXDist = 0.0;
        double maxYDist = 0.0;

        protected ScreenParticleBuilder(ScreenParticleType<?> type) {
            this.type = type;
            this.data = new ScreenParticleOptions(type);
        }

        public ScreenParticleBuilder overwriteAnimator(SimpleParticleOptions.Animator animator) {
            this.data.animator = animator;
            return this;
        }

        public ScreenParticleBuilder overwriteRenderType(ParticleRenderType renderType) {
            this.data.renderType = renderType;
            return this;
        }

        public ScreenParticleBuilder overwriteRenderOrder(ScreenParticle.RenderOrder renderOrder) {
            this.data.renderOrder = renderOrder;
            return this;
        }

        public ScreenParticleBuilder centerOnStack(ItemStack stack) {
            this.data.stack = stack;
            return this;
        }

        public ScreenParticleBuilder centerOnStack(ItemStack stack, float xOffset, float yOffset) {
            this.data.stack = stack;
            this.data.xOffset = xOffset;
            this.data.yOffset = yOffset;
            return this;
        }

        public ScreenParticleBuilder setColorEasing(Easing easing) {
            this.data.colorCurveEasing = easing;
            return this;
        }

        public ScreenParticleBuilder setColorCurveMultiplier(float colorCurveMultiplier) {
            this.data.colorCurveMultiplier = colorCurveMultiplier;
            return this;
        }

        public ScreenParticleBuilder setColor(float r, float g, float b) {
            return this.setColor(r, g, b, this.data.alpha1, r, g, b, this.data.alpha2);
        }

        public ScreenParticleBuilder setColor(float r, float g, float b, float a) {
            return this.setColor(r, g, b, a, r, g, b, a);
        }

        public ScreenParticleBuilder setColor(float r, float g, float b, float a1, float a2) {
            return this.setColor(r, g, b, a1, r, g, b, a2);
        }

        public ScreenParticleBuilder setColor(float r1, float g1, float b1, float r2, float g2, float b2) {
            return this.setColor(r1, g1, b1, this.data.alpha1, r2, g2, b2, this.data.alpha2);
        }

        public ScreenParticleBuilder setColor(float r1, float g1, float b1, float r2, float g2, float b2, float a) {
            return this.setColor(r1, g1, b1, a, r2, g2, b2, a);
        }

        public ScreenParticleBuilder setColor(float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2) {
            this.data.r1 = r1;
            this.data.g1 = g1;
            this.data.b1 = b1;
            this.data.alpha1 = a1;
            this.data.r2 = r2;
            this.data.g2 = g2;
            this.data.b2 = b2;
            this.data.alpha2 = a2;
            return this;
        }

        public ScreenParticleBuilder setColor(Color c1, Color c2) {
            this.data.r1 = (float)c1.getRed() / 255.0f;
            this.data.g1 = (float)c1.getGreen() / 255.0f;
            this.data.b1 = (float)c1.getBlue() / 255.0f;
            this.data.r2 = (float)c2.getRed() / 255.0f;
            this.data.g2 = (float)c2.getGreen() / 255.0f;
            this.data.b2 = (float)c2.getBlue() / 255.0f;
            return this;
        }

        public ScreenParticleBuilder setAlphaEasing(Easing startEasing, Easing endEasing) {
            this.data.alphaCurveStartEasing = startEasing;
            this.data.alphaCurveEndEasing = endEasing;
            return this;
        }

        public ScreenParticleBuilder setAlphaEasing(Easing easing) {
            this.data.alphaCurveStartEasing = easing;
            return this;
        }

        public ScreenParticleBuilder setAlphaCurveMultiplier(float alphaCurveMultiplier) {
            this.data.alphaCurveMultiplier = alphaCurveMultiplier;
            return this;
        }

        public ScreenParticleBuilder setAlpha(float alpha) {
            return this.setAlpha(alpha, alpha);
        }

        public ScreenParticleBuilder setAlpha(float alpha1, float alpha2) {
            return this.setAlpha(alpha1, alpha2, alpha2);
        }

        public ScreenParticleBuilder setAlpha(float alpha1, float alpha2, float alpha3) {
            this.data.alpha1 = alpha1;
            this.data.alpha2 = alpha2;
            this.data.alpha3 = alpha3;
            return this;
        }

        public ScreenParticleBuilder setScaleEasing(Easing startEasing, Easing endEasing) {
            this.data.scaleCurveStartEasing = startEasing;
            this.data.scaleCurveEndEasing = endEasing;
            return this;
        }

        public ScreenParticleBuilder setScaleEasing(Easing easing) {
            this.data.scaleCurveStartEasing = easing;
            return this;
        }

        public ScreenParticleBuilder setScaleCurveMultiplier(float scaleCurveMultiplier) {
            this.data.scaleCurveMultiplier = scaleCurveMultiplier;
            return this;
        }

        public ScreenParticleBuilder setScale(float scale) {
            return this.setScale(scale, scale);
        }

        public ScreenParticleBuilder setScale(float scale1, float scale2) {
            return this.setScale(scale1, scale2, scale2);
        }

        public ScreenParticleBuilder setScale(float scale1, float scale2, float scale3) {
            this.data.scale1 = scale1;
            this.data.scale2 = scale2;
            this.data.scale3 = scale3;
            return this;
        }

        public ScreenParticleBuilder enableGravity() {
            this.data.gravity = true;
            return this;
        }

        public ScreenParticleBuilder disableGravity() {
            this.data.gravity = false;
            return this;
        }

        public ScreenParticleBuilder enableNoClip() {
            this.data.noClip = true;
            return this;
        }

        public ScreenParticleBuilder disableNoClip() {
            this.data.noClip = false;
            return this;
        }

        public ScreenParticleBuilder setSpinEasing(Easing easing) {
            this.data.spinEasing = easing;
            return this;
        }

        public ScreenParticleBuilder setSpinCurveMultiplier(float spinCurveMultiplier) {
            this.data.spinCurveMultiplier = spinCurveMultiplier;
            return this;
        }

        public ScreenParticleBuilder setSpinOffset(float spinOffset) {
            this.data.spinOffset = spinOffset;
            return this;
        }

        public ScreenParticleBuilder setSpin(float spin) {
            return this.setSpin(spin, spin);
        }

        public ScreenParticleBuilder setSpin(float spin1, float spin2) {
            this.data.spin1 = spin1;
            this.data.spin2 = spin2;
            return this;
        }

        public ScreenParticleBuilder setLifetime(int lifetime) {
            this.data.lifetime = lifetime;
            return this;
        }

        public ScreenParticleBuilder setMotionCurveMultiplier(float motionCurveMultiplier) {
            this.data.motionCurveMultiplier = motionCurveMultiplier;
            return this;
        }

        public ScreenParticleBuilder randomMotion(double maxSpeed) {
            return this.randomMotion(maxSpeed, maxSpeed);
        }

        public ScreenParticleBuilder randomMotion(double maxXSpeed, double maxYSpeed) {
            this.maxXSpeed = maxXSpeed;
            this.maxYSpeed = maxYSpeed;
            return this;
        }

        public ScreenParticleBuilder addMotion(double vx, double vy) {
            this.vx += vx;
            this.vy += vy;
            return this;
        }

        public ScreenParticleBuilder setMotion(double vx, double vy) {
            this.vx = vx;
            this.vy = vy;
            return this;
        }

        public ScreenParticleBuilder setForcedMotion(Vector3f startingMotion, Vector3f endingMotion) {
            this.data.forcedMotion = true;
            this.data.startingMotion = startingMotion;
            this.data.endingMotion = endingMotion;
            return this;
        }

        public ScreenParticleBuilder disableForcedMotion() {
            this.data.forcedMotion = false;
            return this;
        }

        public ScreenParticleBuilder randomOffset(double maxDistance) {
            return this.randomOffset(maxDistance, maxDistance);
        }

        public ScreenParticleBuilder randomOffset(double maxXDist, double maxYDist) {
            this.maxXDist = maxXDist;
            this.maxYDist = maxYDist;
            return this;
        }

        public ScreenParticleBuilder spawnCircle(double x, double y, double distance, double currentCount, double totalCount) {
            double xSpeed = (double)random.nextFloat() * this.maxXSpeed;
            double ySpeed = (double)random.nextFloat() * this.maxYSpeed;
            double theta = Math.PI * 2 / totalCount;
            double finalAngle = currentCount / totalCount + theta * currentCount;
            double dx2 = distance * Math.cos(finalAngle);
            double dz2 = distance * Math.sin(finalAngle);
            Vector3d vector2f = new Vector3d(dx2, 0.0, dz2);
            this.vx = vector2f.f_86214_ * xSpeed;
            double yaw2 = (double)random.nextFloat() * Math.PI * 2.0;
            double pitch2 = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
            double xDist = (double)random.nextFloat() * this.maxXDist;
            double yDist = (double)random.nextFloat() * this.maxYDist;
            this.dx = Math.sin(yaw2) * Math.cos(pitch2) * xDist;
            this.dy = Math.sin(pitch2) * yDist;
            this.data.xOrigin = (float)x;
            this.data.yOrigin = (float)y;
            ScreenParticleHandler.addParticle(this.data, x + this.dx + dx2, y + this.dy + dz2, this.vx, ySpeed);
            return this;
        }

        public ScreenParticleBuilder spawn(double x, double y) {
            double yaw = (double)random.nextFloat() * Math.PI * 2.0;
            double pitch = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
            double xSpeed = (double)random.nextFloat() * this.maxXSpeed;
            double ySpeed = (double)random.nextFloat() * this.maxYSpeed;
            this.vx += Math.sin(yaw) * Math.cos(pitch) * xSpeed;
            this.vy += Math.sin(pitch) * ySpeed;
            double yaw2 = (double)random.nextFloat() * Math.PI * 2.0;
            double pitch2 = (double)random.nextFloat() * Math.PI - 1.5707963267948966;
            double xDist = (double)random.nextFloat() * this.maxXDist;
            double yDist = (double)random.nextFloat() * this.maxYDist;
            this.dx = Math.sin(yaw2) * Math.cos(pitch2) * xDist;
            this.dy = Math.sin(pitch2) * yDist;
            this.data.xOrigin = (float)x;
            this.data.yOrigin = (float)y;
            ScreenParticleHandler.addParticle(this.data, x + this.dx, y + this.dy, this.vx, this.vy);
            return this;
        }

        public ScreenParticleBuilder repeat(double x, double y, int n) {
            for (int i = 0; i < n; ++i) {
                this.spawn(x, y);
            }
            return this;
        }

        public ScreenParticleBuilder repeatCircle(double x, double y, double distance, int times) {
            for (int i = 0; i < times; ++i) {
                this.spawnCircle(x, y, distance, i, times);
            }
            return this;
        }
    }
}

