/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.systems.rendering;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.shaders.Shader;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.sammy.ortus.systems.rendering.ShaderHolder;
import com.sammy.ortus.systems.rendering.UniformData;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.util.GsonHelper;

public class ExtendedShaderInstance
extends ShaderInstance {
    public ExtendedShaderInstance(ResourceProvider pResourceProvider, ResourceLocation location, VertexFormat pVertexFormat) throws IOException {
        super(pResourceProvider, location, pVertexFormat);
    }

    public static ExtendedShaderInstance createShaderInstance(final ShaderHolder shaderHolder, ResourceProvider pResourceProvider, ResourceLocation location, VertexFormat pVertexFormat) throws IOException {
        return new ExtendedShaderInstance(pResourceProvider, location, pVertexFormat){

            @Override
            public ShaderHolder getHolder() {
                return shaderHolder;
            }
        };
    }

    public void setUniformDefaults() {
        this.getHolder().setUniformDefaults();
    }

    public ShaderHolder getHolder() {
        return null;
    }

    public void m_173354_(JsonElement pJson) throws ChainedJsonException {
        if (this.getHolder().uniforms.isEmpty()) {
            super.m_173354_(pJson);
            return;
        }
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)pJson, (String)"uniform");
        String name = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"name");
        int i = Uniform.m_85629_((String)GsonHelper.m_13906_((JsonObject)jsonobject, (String)"type"));
        int j = GsonHelper.m_13927_((JsonObject)jsonobject, (String)"count");
        float[] afloat = new float[Math.max(j, 16)];
        JsonArray jsonarray = GsonHelper.m_13933_((JsonObject)jsonobject, (String)"values");
        if (jsonarray.size() != j && jsonarray.size() > 1) {
            throw new ChainedJsonException("Invalid amount of values specified (expected " + j + ", found " + jsonarray.size() + ")");
        }
        int k = 0;
        for (JsonElement jsonelement : jsonarray) {
            try {
                afloat[k] = GsonHelper.m_13888_((JsonElement)jsonelement, (String)"value");
            }
            catch (Exception exception) {
                ChainedJsonException chainedjsonexception = ChainedJsonException.m_135906_((Exception)exception);
                chainedjsonexception.m_135908_("values[" + k + "]");
                throw chainedjsonexception;
            }
            ++k;
        }
        if (j > 1 && jsonarray.size() == 1) {
            while (k < j) {
                afloat[k] = afloat[0];
                ++k;
            }
        }
        int l = j > 1 && j <= 4 && i < 8 ? j - 1 : 0;
        Uniform uniform = new Uniform(name, i + l, j, (Shader)this);
        if (i <= 3) {
            uniform.m_7401_((int)afloat[0], (int)afloat[1], (int)afloat[2], (int)afloat[3]);
            if (this.getHolder().uniforms.contains(name)) {
                this.getHolder().defaultUniformData.add(new UniformData.IntegerUniformData(name, i, new int[]{(int)afloat[0], (int)afloat[1], (int)afloat[2], (int)afloat[3]}));
            }
        } else if (i <= 7) {
            uniform.m_5808_(afloat[0], afloat[1], afloat[2], afloat[3]);
        } else {
            uniform.m_5941_(Arrays.copyOfRange(afloat, 0, j));
        }
        if (i > 3 && this.getHolder().uniforms.contains(name)) {
            this.getHolder().defaultUniformData.add(new UniformData.FloatUniformData(name, i, afloat));
        }
        this.f_173331_.add(uniform);
    }
}

