/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.systems.recipe;

import com.google.gson.JsonObject;
import com.sammy.ortus.systems.recipe.IRecipeComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemWithCount
implements IRecipeComponent {
    public final Item item;
    public final int count;

    public ItemWithCount(Item item, int count) {
        this.item = item;
        this.count = count;
    }

    public ItemWithCount(ItemStack stack) {
        this(stack.m_41720_(), stack.m_41613_());
    }

    public static ItemWithCount deserialize(JsonObject inputObject) {
        ItemStack input = ShapedRecipe.m_151274_((JsonObject)inputObject);
        return new ItemWithCount(input);
    }

    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.item).toString());
        if (this.getCount() > 1) {
            object.addProperty("count", (Number)this.getCount());
        }
        return object;
    }

    @Override
    public ItemStack getStack() {
        return new ItemStack((ItemLike)this.getItem(), this.getCount());
    }

    @Override
    public ArrayList<ItemStack> getStacks() {
        return new ArrayList<ItemStack>(List.of(this.getStack()));
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return stack.m_41720_().equals(this.getItem()) && stack.m_41613_() >= this.getCount();
    }
}

