/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.ortus.systems.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sammy.ortus.helpers.ItemHelper;
import com.sammy.ortus.systems.recipe.IRecipeComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class IngredientWithCount
implements IRecipeComponent {
    public final Ingredient ingredient;
    public final int count;

    public IngredientWithCount(Ingredient ingredient, int count) {
        this.ingredient = ingredient;
        this.count = count;
    }

    @Override
    public ItemStack getStack() {
        return new ItemStack((ItemLike)this.getItem(), this.getCount());
    }

    @Override
    public ArrayList<ItemStack> getStacks() {
        return ItemHelper.copyWithNewCount(List.of(this.ingredient.m_43908_()), this.getCount());
    }

    @Override
    public Item getItem() {
        return this.ingredient.m_43908_()[0].m_41720_();
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.ingredient.test(stack) && stack.m_41613_() >= this.getCount();
    }

    public static IngredientWithCount read(FriendlyByteBuf buffer) {
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        byte count = buffer.readByte();
        return new IngredientWithCount(ingredient, count);
    }

    public void write(FriendlyByteBuf buffer) {
        this.ingredient.m_43923_(buffer);
        buffer.writeByte(this.count);
    }

    public static IngredientWithCount deserialize(JsonObject object) {
        Ingredient input = object.has("ingredient_list") ? Ingredient.m_43917_((JsonElement)object.get("ingredient_list")) : Ingredient.m_43917_((JsonElement)object);
        int count = GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1);
        return new IngredientWithCount(input, count);
    }

    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        JsonElement serialize = this.ingredient.m_43942_();
        if (serialize.isJsonObject()) {
            object = serialize.getAsJsonObject();
        } else {
            object.add("ingredient_list", this.ingredient.m_43942_());
        }
        object.addProperty("count", (Number)this.count);
        return object;
    }
}

